/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.utils;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import sba.sl.impl.bukkit.BukkitFeature;

public final class Version {
    public static final int MAJOR_VERSION;
    public static final int MINOR_VERSION;
    public static final int PATCH_VERSION;

    public static boolean isVersion(int major, int minor) {
        return Version.isVersion(major, minor, 0);
    }

    public static boolean isVersion(int major, int minor, int patch) {
        return MAJOR_VERSION > major || MAJOR_VERSION >= major && (MINOR_VERSION > minor || MINOR_VERSION >= minor && PATCH_VERSION >= patch);
    }

    @Generated
    private Version() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Matcher matcher;
        Pattern versionPattern;
        if (BukkitFeature.BUKKIT_GET_MINECRAFT_VERSION.isSupported()) {
            versionPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.?(\\d+)?");
            matcher = versionPattern.matcher(Bukkit.getMinecraftVersion());
        } else {
            versionPattern = Pattern.compile("\\(MC: (\\d+)\\.(\\d+)\\.?(\\d+)?");
            matcher = versionPattern.matcher(Bukkit.getVersion());
        }
        int majorVersion = 1;
        int minorVersion = 0;
        int patchVersion = 0;
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            try {
                majorVersion = Integer.parseInt(matchResult.group(1), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                minorVersion = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (matchResult.groupCount() >= 3) {
                try {
                    patchVersion = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        MAJOR_VERSION = majorVersion;
        MINOR_VERSION = minorVersion;
        PATCH_VERSION = patchVersion;
    }
}

