/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world.difficulty;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Difficulty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.world.difficulty.BukkitDifficultyType;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.impl.world.difficulty.DifficultyRegistry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;
import sba.sl.w.difficulty.DifficultyType;

@Service
public class BukkitDifficultyRegistry
extends DifficultyRegistry {
    public BukkitDifficultyRegistry() {
        this.specialType(Difficulty.class, BukkitDifficultyType::new);
    }

    @Override
    @Nullable
    protected DifficultyType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            Difficulty value = Difficulty.valueOf((String)location.path().toUpperCase(Locale.ROOT));
            return new BukkitDifficultyType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull DifficultyType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Difficulty, DifficultyType>(() -> Arrays.stream(Difficulty.values()), BukkitDifficultyType::new, difficulty -> ResourceLocation.of(difficulty.name()), (difficulty, literal) -> difficulty.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (difficulty, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

