/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world.gamerule;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.GameRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.world.gamerule.BukkitGameRuleType1_13;
import sba.sl.impl.bukkit.world.gamerule.BukkitGameRuleType1_8;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.impl.world.gamerule.GameRuleRegistry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.StringUtils;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;
import sba.sl.w.gamerule.GameRuleType;

@Service
public class BukkitGameRuleRegistry
extends GameRuleRegistry {
    @NotNull
    private final @NotNull List<@NotNull String> compat;

    public BukkitGameRuleRegistry() {
        if (!BukkitFeature.GAME_RULE_API.isSupported()) {
            this.compat = List.of("doFireTick", "mobGriefing", "keepInventory", "doMobSpawning", "doMobLoot", "doTileDrops", "commandBlockOutput", "naturalRegeneration", "doDaylightCycle", "logAdminCommands", "showDeathMessages", "randomTickSpeed", "sendCommandFeedback", "reducedDebugInfo", "doEntityDrops", "spectatorsGenerateChunks", "spawnRadius", "disableElytraMovementCheck", "doWeatherCycle", "maxEntityCramming", "doLimitedCrafting", "maxCommandChainLength", "announceAdvancements", "gameLoopFunction");
        } else {
            this.compat = List.of();
            this.specialType(GameRule.class, BukkitGameRuleType1_13::new);
        }
    }

    @Override
    @Nullable
    protected GameRuleType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        if (BukkitFeature.GAME_RULE_API.isSupported()) {
            @Nullable GameRule g = null;
            if (location.path().contains("_")) {
                g = GameRule.getByName((String)StringUtils.snakeToCamel(location.path()));
            } else {
                for (GameRule r : GameRule.values()) {
                    if (!r.getName().equalsIgnoreCase(location.path())) continue;
                    g = r;
                    break;
                }
            }
            if (g != null) {
                return new BukkitGameRuleType1_13(g);
            }
        } else {
            Optional<String> str = this.compat.stream().filter(s -> s.equalsIgnoreCase(location.path().replace("_", ""))).findFirst();
            if (str.isPresent()) {
                return new BukkitGameRuleType1_8(str.get());
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull GameRuleType> getRegistryItemStream0() {
        if (BukkitFeature.GAME_RULE_API.isSupported()) {
            return new SimpleRegistryItemStream<GameRule, GameRuleType>(() -> Arrays.stream(GameRule.values()), BukkitGameRuleType1_13::new, gameRule -> ResourceLocation.of(gameRule.getName()), (gameRule, literal) -> gameRule.getName().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (gameRule, namespace) -> "minecraft".equals(namespace), List.of());
        }
        return new SimpleRegistryItemStream<String, GameRuleType>(this.compat::stream, BukkitGameRuleType1_8::new, ResourceLocation::of, (environment, literal) -> environment.toLowerCase(Locale.ROOT).contains((CharSequence)literal), (environment, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

