/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.backports;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.backports.BasePortedComponent;

@ApiStatus.Internal
public class ScorePortedComponent
extends BasePortedComponent {
    @NotNull
    private String name;
    @NotNull
    private String objective;
    @Nullable
    private String value;

    public ScorePortedComponent(@NotNull ScorePortedComponent component) {
        super(component);
        this.name = component.name;
        this.objective = component.objective;
        this.value = component.value;
    }

    @Override
    @NotNull
    public ScorePortedComponent duplicate() {
        return new ScorePortedComponent(this);
    }

    @NotNull
    public String toPlainText() {
        return (this.value != null ? this.value : "") + super.toPlainText();
    }

    @NotNull
    public String toLegacyText() {
        return (this.value != null ? this.value : "") + super.toLegacyText();
    }

    @Override
    public void write(@NotNull JsonObject out) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("objective", this.objective);
        if (this.value != null && !this.value.isEmpty()) {
            json.addProperty("value", this.value);
        }
        out.add("score", (JsonElement)json);
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public String getObjective() {
        return this.objective;
    }

    @Nullable
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setObjective(@NotNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.objective = objective;
    }

    @Generated
    public void setValue(@Nullable String value) {
        this.value = value;
    }

    @Generated
    public String toString() {
        return "ScorePortedComponent(name=" + this.getName() + ", objective=" + this.getObjective() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public ScorePortedComponent(@NotNull String name, @NotNull String objective) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.name = name;
        this.objective = objective;
    }

    @Generated
    public ScorePortedComponent(@NotNull String name, @NotNull String objective, @Nullable String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.name = name;
        this.objective = objective;
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScorePortedComponent)) {
            return false;
        }
        ScorePortedComponent other = (ScorePortedComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$objective = this.getObjective();
        String other$objective = other.getObjective();
        if (this$objective == null ? other$objective != null : !this$objective.equals(other$objective)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScorePortedComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : $objective.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

