/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.item;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.ItemTypeHolder;
import sba.sl.i.ItemType;
import sba.sl.impl.ItemBlockIdsRemapper;
import sba.sl.impl.utils.registry.SimpleRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
@ApiStatus.Internal
public abstract class ItemTypeRegistry
extends SimpleRegistry<ItemType> {
    @Nullable
    private static ItemTypeRegistry registry;
    @Nullable
    private static ItemType cachedAir;

    public ItemTypeRegistry() {
        super(ItemType.class);
        Preconditions.checkArgument(registry == null, "ItemTypeRegistry is already initialized!");
        registry = this;
    }

    @NotNull
    public static ItemTypeRegistry getInstance() {
        return Preconditions.checkNotNull(registry, "ItemTypeRegistry is not initialized yet!");
    }

    @NotNull
    public static ItemType colorize(@NotNull ItemType holder, @NotNull String color) {
        Preconditions.checkNotNull(registry, "ItemTypeRegistry is not initialized yet!");
        return ItemBlockIdsRemapper.colorableItems.entrySet().stream().filter(c -> ((Predicate)c.getKey()).test(holder)).map(Map.Entry::getValue).findFirst().flatMap(fun -> (Optional)fun.apply(color)).orElse(holder);
    }

    @Override
    public void mapAlias(@NotNull String mappingKey, @NotNull String alias) {
        super.mapAlias(mappingKey, alias);
    }

    @NotNull
    public static ItemType getCachedAir() {
        if (cachedAir == null) {
            cachedAir = (ItemType)Preconditions.checkNotNull(registry, "ItemTypeRegistry is not initialized yet!").resolveMapping("minecraft:air");
            Preconditions.checkNotNullIllegal(cachedAir, "Could not find item type: minecraft:air");
        }
        return cachedAir;
    }

    static {
        ItemTypeHolder.Provider.registerProvider(o -> Objects.requireNonNull((ItemType)ItemTypeRegistry.getInstance().resolveMapping(o), "Could not wrap " + String.valueOf(o) + " to ItemType"));
    }
}

