/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.item.tags;

import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.i.ItemType;
import sba.sl.impl.tags.TagPortHelper;

@ApiStatus.Internal
public final class ModernItemTagsBackPorts {
    public static @Nullable List<@NotNull String> getPortedTags(@NotNull ItemType itemType, @NotNull @NotNull Predicate<@NotNull String> nativeTagChecker) {
        if (!Server.isVersion(1, 13)) {
            return List.of();
        }
        TagPortHelper helper = new TagPortHelper(nativeTagChecker);
        if (!Server.isVersion(1, 14)) {
            if (itemType.is("music_disc_13", "music_disc_cat", "music_disc_blocks", "music_disc_chirp", "music_disc_far", "music_disc_mall", "music_disc_mellohi", "music_disc_stal", "music_disc_strad", "music_disc_ward", "music_disc_11", "music_disc_wait")) {
                helper.port("music_discs");
            }
            if (itemType.is("oak_sign", "spruce_sign", "birch_sign", "acacia_sign", "jungle_sign", "dark_oak_sign")) {
                helper.port("signs");
            }
            if (itemType.is("dandelion", "poppy", "blue_orchid", "allium", "azure_bluet", "red_tulip", "orange_tulip", "white_tulip", "pink_tulip", "oxeye_daisy")) {
                helper.port("small_flowers");
            }
            if (itemType.is("cobblestone_wall", "mossy_cobblestone_wall")) {
                helper.port("walls");
            }
            if (itemType.is("red_bed", "black_bed", "blue_bed", "brown_bed", "cyan_bed", "gray_bed", "green_bed", "light_blue_bed", "light_gray_bed", "lime_bed", "magenta_bed", "orange_bed", "pink_bed", "purple_bed", "white_bed", "yellow_bed")) {
                helper.port("beds");
            }
            if (itemType.is("oak_fence", "acacia_fence", "dark_oak_fence", "spruce_fence", "birch_fence", "jungle_fence")) {
                helper.port("wooden_fences");
            }
            if (helper.hasTag("wooden_fences") || itemType.is((Object)"nether_brick_fence")) {
                helper.port("fences");
            }
        }
        if (!Server.isVersion(1, 15)) {
            if (itemType.is("sunflower", "lilac", "peony", "rose_bush")) {
                helper.port("tall_flowers");
            }
            if (helper.hasTag("small_flowers", "tall_flowers")) {
                helper.port("flowers");
            }
            if (itemType.is("written_book", "writable_book")) {
                helper.port("lectern_books");
            }
        }
        if (!Server.isVersion(1, 16)) {
            if (itemType.is("emerald", "diamond", "gold_ingot", "iron_ingot")) {
                helper.port("beacon_payment_items");
            }
            if (itemType.is((Object)"gold_ore")) {
                helper.port("gold_ores");
            }
            if (helper.hasTag("dark_oak_logs", "oak_logs", "acacia_logs", "birch_logs", "jungle_logs", "spruce_logs")) {
                helper.port("logs_that_burn");
            }
            if (itemType.is((Object)"cobblestone")) {
                helper.port("furnace_materials");
                helper.port("stone_tool_materials");
            }
            if (helper.hasTag("music_discs")) {
                helper.port("creeper_drop_music_discs");
            }
        }
        if (!Server.isVersion(1, 16, 2)) {
            if (helper.hasTag("furnace_material")) {
                helper.port("stone_crafting_materials");
            }
        } else if (helper.hasTag("stone_crafting_materials")) {
            helper.port("furnace_material");
        }
        if (!Server.isVersion(1, 17)) {
            if (itemType.is((Object)"leather")) {
                helper.port("ignored_by_piglin_babies");
            }
            if (itemType.is("porkchop", "cooked_porkchop")) {
                helper.port("piglin_food");
            }
            if (itemType.is("sweet_berries", "glow_berries")) {
                helper.port("fox_food");
            }
            if (itemType.is((Object)"diamond_ore")) {
                helper.port("diamond_ores");
            }
            if (itemType.is((Object)"iron_ore")) {
                helper.port("iron_ores");
            }
            if (itemType.is((Object)"lapis_ore")) {
                helper.port("lapis_ores");
            }
            if (itemType.is((Object)"redstone_ore")) {
                helper.port("redstone_ores");
            }
            if (itemType.is((Object)"coal_ore")) {
                helper.port("coal_ores");
            }
            if (itemType.is((Object)"emerald_ore")) {
                helper.port("emerald_ores");
            }
        }
        if (!Server.isVersion(1, 18)) {
            if (itemType.is("dirt", "grass_block", "podzol", "coarse_dirt", "mycelium", "rooted_dirt", "moss_block")) {
                helper.port("dirt");
            }
            if (itemType.is("terracotta", "white_terracotta", "orange_terracotta", "magenta_terracotta", "light_blue_terracotta", "yellow_terracotta", "lime_terracotta", "pink_terracotta", "gray_terracotta", "light_gray_terracotta", "cyan_terracotta", "purple_terracotta", "blue_terracotta", "brown_terracotta", "green_terracotta", "red_terracotta", "black_terracotta")) {
                helper.port("terracotta");
            }
        }
        if (!Server.isVersion(1, 19)) {
            if (helper.hasTag("carpets")) {
                helper.port("wool_carpets");
            }
            if (itemType.is((Object)"compass")) {
                helper.port("compasses");
            }
            if (itemType.is("nether_wart_block", "warped_wart_block")) {
                helper.port("wart_blocks");
            }
            if (helper.hasTag("logs", "leaves", "wart_blocks")) {
                helper.port("completes_find_tree_tutorial");
            }
            if (helper.hasTag("occludes_vibration_signals")) {
                helper.port("dampens_vibrations");
            }
            if (itemType.is("acacia_log", "birch_log", "oak_log", "jungle_log", "spruce_log", "dark_oak_log")) {
                helper.port("overworld_natural_logs");
            }
        } else {
            if (helper.hasTag("wool_carpets")) {
                helper.port("carpets");
            }
            if (helper.hasTag("dampens_vibrations")) {
                helper.port("occludes_vibration_signals");
            }
        }
        if (!Server.isVersion(1, 19, 3)) {
            if (itemType.is("flint_and_steel", "fire_charge")) {
                helper.port("creeper_igniters");
            }
            if (itemType.is("book", "written_book", "enchanted_book", "writable_book")) {
                helper.port("bookshelf_books");
            }
            if (itemType.is("acacia_fence_gate", "birch_fence_gate", "dark_oak_fence_gate", "jungle_fence_gate", "oak_fence_gate", "spruce_fence_gate", "crimson_fence_gate", "warped_fence_gate", "mangrove_fence_gate")) {
                helper.port("fence_gates");
            }
        } else if (itemType.is("acacia_log", "birch_log", "oak_log", "jungle_log", "spruce_log", "dark_oak_log")) {
            helper.port("overworld_natural_logs");
        }
        if (!Server.isVersion(1, 19, 4)) {
            if (itemType.is("minecraft:diamond_axe", "minecraft:golden_axe", "minecraft:iron_axe", "minecraft:netherite_axe", "minecraft:stone_axe", "minecraft:wooden_axe")) {
                helper.port("axes");
            }
            if (itemType.is("minecraft:diamond_hoe", "minecraft:golden_hoe", "minecraft:iron_hoe", "minecraft:netherite_hoe", "minecraft:stone_hoe", "minecraft:wooden_hoe")) {
                helper.port("hoes");
            }
            if (itemType.is("minecraft:diamond_pickaxe", "minecraft:golden_pickaxe", "minecraft:iron_pickaxe", "minecraft:netherite_pickaxe", "minecraft:stone_pickaxe", "minecraft:wooden_pickaxe")) {
                helper.port("pickaxes");
            }
            if (itemType.is("minecraft:diamond_shovel", "minecraft:golden_shovel", "minecraft:iron_shovel", "minecraft:netherite_shovel", "minecraft:stone_shovel", "minecraft:wooden_shovel")) {
                helper.port("shovels");
            }
            if (itemType.is("minecraft:diamond_sword", "minecraft:golden_sword", "minecraft:iron_sword", "minecraft:netherite_sword", "minecraft:stone_sword", "minecraft:wooden_sword")) {
                helper.port("swords");
            }
        }
        if (!Server.isVersion(1, 20, 5)) {
            if (itemType.is("minecraft:chainmail_chestplate", "minecraft:diamond_chestplate", "minecraft:golden_chestplate", "minecraft:iron_chestplate", "minecraft:leather_chestplate", "minecraft:netherite_chestplate")) {
                helper.port("chest_armor");
                helper.port("enchantable/chest_armor");
                helper.port("enchantable/armor");
            }
            if (itemType.is("minecraft:chainmail_boots", "minecraft:diamond_boots", "minecraft:golden_boots", "minecraft:iron_boots", "minecraft:leather_boots", "minecraft:netherite_boots")) {
                helper.port("foot_armor");
                helper.port("enchantable/foot_armor");
                helper.port("enchantable/armor");
            }
            if (itemType.is("minecraft:chainmail_helmet", "minecraft:diamond_helmet", "minecraft:golden_helmet", "minecraft:iron_helmet", "minecraft:leather_helmet", "minecraft:netherite_helmet", "minecraft:turtle_helmet")) {
                helper.port("head_armor");
                helper.port("enchantable/head_armor");
                helper.port("enchantable/armor");
            }
            if (itemType.is("minecraft:chainmail_leggings", "minecraft:diamond_leggings", "minecraft:golden_leggings", "minecraft:iron_leggings", "minecraft:leather_leggings", "minecraft:netherite_leggings")) {
                helper.port("leg_armor");
                helper.port("enchantable/leg_armor");
                helper.port("enchantable/armor");
            }
            if (itemType.is("minecraft:creeper_head", "minecraft:dragon_head", "minecraft:piglin_head", "minecraft:player_head", "minecraft:skeleton_skull", "minecraft:wither_skeleton_skull", "minecraft:zombie_head")) {
                helper.port("skulls");
            }
        }
        return helper.getPorts();
    }

    @Generated
    private ModernItemTagsBackPorts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

