/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.cache;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.utils.cache.Cache;
import sba.sl.impl.utils.cache.CacheItem;

public class LFUCache<K, V>
implements Cache<K, V> {
    private final int capacity;
    @NotNull
    private final @NotNull Map<@NotNull K, CacheItem<K, V>> map;
    @Nullable
    private CacheItem<K, V> first;
    @Nullable
    private CacheItem<K, V> last;

    public LFUCache(int size) {
        this.capacity = size;
        this.map = new HashMap<K, CacheItem<K, V>>(size);
    }

    @Override
    public void put(@NotNull K key, @NotNull V value) {
        CacheItem<K, V> node = new CacheItem<K, V>(key, value);
        if (!this.map.containsKey(key)) {
            if (this.size() >= this.capacity) {
                this.deleteNode(this.first);
            }
            if (this.first != null) {
                node.setNext(this.first);
                this.first.setPrevious(node);
            }
            this.first = node;
            if (this.last == null) {
                this.last = node;
            }
        }
        this.map.put(key, node);
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        CacheItem<K, V> node = this.map.get(key);
        node.incrementHitCount();
        this.reorder(node);
        return node.getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.first = null;
        this.last = null;
        this.map.clear();
    }

    private void deleteNode(@Nullable CacheItem<K, V> node) {
        if (node == null) {
            return;
        }
        if (this.last == node) {
            this.last = node.getPrevious();
        }
        if (this.first == node) {
            this.first = node.getNext();
        }
        this.map.remove(node.getKey());
    }

    private void reorder(@NotNull CacheItem<K, V> node) {
        if (this.last == node) {
            return;
        }
        CacheItem<K, V> nextNode = node.getNext();
        while (nextNode != null && nextNode.getHitCount() <= node.getHitCount()) {
            if (this.first == node) {
                this.first = nextNode;
            }
            if (node.getPrevious() != null) {
                node.getPrevious().setNext(nextNode);
            }
            nextNode.setPrevious(node.getPrevious());
            node.setPrevious(nextNode);
            node.setNext(nextNode.getNext());
            if (nextNode.getNext() != null) {
                nextNode.getNext().setPrevious(node);
            }
            nextNode.setNext(node);
            nextNode = node.getNext();
        }
        if (node.getNext() == null) {
            this.last = node;
        }
    }
}

