/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CollectionLinkedToCollection<L, O>
implements Collection<L> {
    @NotNull
    protected final Collection<O> original;
    @NotNull
    protected final Function<L, O> linkToOriginal;
    @NotNull
    protected final Function<O, L> originalToLink;

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.original.contains(this.linkToOriginal.apply(o));
    }

    @Override
    @NotNull
    public Iterator<L> iterator() {
        final Iterator<O> realIterator = this.original.iterator();
        return new Iterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return CollectionLinkedToCollection.this.originalToLink.apply(realIterator.next());
            }

            @Override
            public void remove() {
                realIterator.remove();
            }
        };
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.original.stream().map(this.originalToLink).toArray();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        return this.original.stream().map(this.originalToLink).toArray((int value) -> (Object[])Array.newInstance(a.getClass().getComponentType(), value));
    }

    @Override
    public boolean add(L e) {
        O a = this.linkToOriginal.apply(e);
        if (a != null) {
            return this.original.add(a);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        O a = this.linkToOriginal.apply(o);
        if (a != null) {
            return this.original.remove(a);
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.original.containsAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends L> c) {
        return this.original.addAll(c.stream().map(this.linkToOriginal).collect(Collectors.toList()));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.original.removeAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.original.retainAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.original.clear();
    }

    @Generated
    public CollectionLinkedToCollection(@NotNull Collection<O> original, @NotNull Function<L, O> linkToOriginal, @NotNull Function<O, L> originalToLink) {
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (linkToOriginal == null) {
            throw new NullPointerException("linkToOriginal is marked non-null but is null");
        }
        if (originalToLink == null) {
            throw new NullPointerException("originalToLink is marked non-null but is null");
        }
        this.original = original;
        this.linkToOriginal = linkToOriginal;
        this.originalToLink = originalToLink;
    }
}

