/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.utils.cache.Cache;
import sba.sl.impl.utils.cache.LFUCache;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public abstract class Registry<T extends RegistryItem> {
    @NotNull
    protected final Class<T> type;
    @NotNull
    private final @NotNull Cache<@NotNull Object, @NotNull T> cache = new LFUCache<Object, T>(200);
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, Function<@NotNull Object, @Nullable T>> specialMapping = new HashMap();
    @Nullable
    private RegistryItemStream<T> cachedBasicStream;

    @Contract(value="null -> null")
    @Nullable
    public final T resolveMapping(@Nullable Object object) {
        RegistryItem cachedRow;
        if (object == null) {
            return null;
        }
        if (this.type.isInstance(object)) {
            return (T)((RegistryItem)object);
        }
        if (!this.specialMapping.isEmpty()) {
            for (Map.Entry<Class<?>, Function<Object, T>> sm : this.specialMapping.entrySet()) {
                if (!sm.getKey().isInstance(object)) continue;
                return (T)((RegistryItem)sm.getValue().apply(object));
            }
        }
        if ((cachedRow = (RegistryItem)this.cache.get(object)) != null) {
            return (T)cachedRow;
        }
        T result = this.resolveMapping0(object);
        if (result != null) {
            this.cache.put(object, result);
            return result;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    protected abstract T resolveMapping0(@NotNull Object var1);

    @ApiStatus.Internal
    protected <E> void specialType(@NotNull Class<E> eClass, @NotNull @NotNull Function<@NotNull E, @Nullable T> function) {
        this.specialMapping.put(eClass, function);
    }

    @NotNull
    public @NotNull RegistryItemStream<@NotNull T> getRegistryItemStream() {
        if (this.cachedBasicStream == null) {
            this.cachedBasicStream = this.getRegistryItemStream0();
        }
        return this.cachedBasicStream;
    }

    @ApiStatus.Internal
    @NotNull
    protected abstract @NotNull RegistryItemStream<@NotNull T> getRegistryItemStream0();

    @Generated
    public Registry(@NotNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }
}

