/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.registry;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.sl.impl.utils.registry.Registry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItem;

public abstract class SimpleRegistry<T extends RegistryItem>
extends Registry<T> {
    @NotNull
    private final @NotNull Map<@NotNull ResourceLocation, ResourceLocation> aliasMap = new HashMap<ResourceLocation, ResourceLocation>();

    @ApiStatus.Internal
    public SimpleRegistry(@NotNull Class<T> type) {
        super(type);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    protected final T resolveMapping0(@NotNull Object object) {
        ResourceLocation location;
        if (object instanceof ConfigurationNode) {
            object = ((ConfigurationNode)object).getString("");
        }
        if ((location = object instanceof ResourceLocation ? (ResourceLocation)object : ResourceLocation.ofNullable(object.toString().trim())) == null) {
            return null;
        }
        T result = this.resolveMappingPlatform(location);
        if (result != null) {
            return result;
        }
        ResourceLocation alias = this.aliasMap.get(location);
        if (alias != null) {
            return this.resolveMappingPlatform(alias);
        }
        return null;
    }

    @ApiStatus.Internal
    protected void mapAlias(@NotNull String location, @NotNull String alias) {
        this.mapAlias(ResourceLocation.of(location), ResourceLocation.of(alias));
    }

    @ApiStatus.Internal
    protected void mapAlias(@NotNull ResourceLocation location, @NotNull ResourceLocation alias) {
        T locT = this.resolveMappingPlatform(location);
        T aliasT = this.resolveMappingPlatform(alias);
        if (locT == null && aliasT != null) {
            this.aliasMap.put(location, alias);
        } else if (locT != null && aliasT == null) {
            this.aliasMap.put(alias, location);
        } else {
            ResourceLocation locA = this.aliasMap.get(location);
            ResourceLocation aliasA = this.aliasMap.get(alias);
            if (locA == null && aliasA != null) {
                this.aliasMap.put(location, aliasA);
            } else if (locA != null && aliasA == null) {
                this.aliasMap.put(alias, locA);
            }
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected abstract T resolveMappingPlatform(@NotNull ResourceLocation var1);
}

