/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.vanilla.packet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.nms.accessors.network.ConnectionProtocol$CodecDataAccessor;
import sba.sl.impl.nms.accessors.network.ConnectionProtocol$PacketSetAccessor;
import sba.sl.impl.nms.accessors.network.ConnectionProtocolAccessor;
import sba.sl.impl.nms.accessors.network.protocol.PacketFlowAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundAddEntityPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundAddMobPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundAddPlayerPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundMoveEntityPacket$PosAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundMoveEntityPacket$PosRotAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundMoveEntityPacket$RotAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundPlayerInfoRemovePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundPlayerInfoUpdatePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundRemoveEntitiesPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundRemoveMobEffectPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundResetScorePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundRotateHeadPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetDisplayObjectivePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetEntityDataPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetEntityMotionPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetEquipmentPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetExperiencePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetObjectivePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetPlayerTeamPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetScorePacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundTeleportEntityPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundUpdateMobEffectPacketAccessor;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddEntityPacket;
import sba.sl.p.ClientboundAddMobPacket;
import sba.sl.p.ClientboundAddPlayerPacket;
import sba.sl.p.ClientboundMoveEntityPacket;
import sba.sl.p.ClientboundPlayerInfoPacket;
import sba.sl.p.ClientboundRemoveEntitiesPacket;
import sba.sl.p.ClientboundRemoveMobEffectPacket;
import sba.sl.p.ClientboundRotateHeadPacket;
import sba.sl.p.ClientboundSetDisplayObjectivePacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.ClientboundSetEntityMotionPacket;
import sba.sl.p.ClientboundSetEquipmentPacket;
import sba.sl.p.ClientboundSetExperiencePacket;
import sba.sl.p.ClientboundSetObjectivePacket;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.p.ClientboundTeleportEntityPacket;
import sba.sl.p.ClientboundUpdateMobEffectPacket;
import sba.sl.u.Preconditions;
import sba.sl.u.reflect.Reflect;

public final class PacketIdMapping {
    @NotNull
    private static final @NotNull Map<@NotNull Class<? extends AbstractPacket>, Class<?>> PACKET_CLASS_TRANSLATE = new ConcurrentHashMap();
    @NotNull
    private static final @NotNull Map<@NotNull Class<? extends AbstractPacket>, Integer> ID_CACHE = new ConcurrentHashMap<Class<? extends AbstractPacket>, Integer>();

    private static void putTranslateSafely(@NotNull Class<? extends AbstractPacket> packetClass, @Nullable Class<?> clazz) {
        if (clazz != null) {
            PACKET_CLASS_TRANSLATE.put(packetClass, clazz);
        }
    }

    private static void putTranslateSafely(@NotNull Class<? extends AbstractPacket> packetClass, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            PACKET_CLASS_TRANSLATE.put(packetClass, clazz);
            return;
        }
    }

    public static Integer getPacketId(@NotNull Class<? extends AbstractPacket> packetClass) {
        Integer packetId;
        Preconditions.checkNotNull(packetClass, "Cannot get packet id of null class!");
        Integer cachedId = ID_CACHE.get(packetClass);
        if (cachedId != null) {
            return cachedId;
        }
        Class<?> vanillaClass = PACKET_CLASS_TRANSLATE.get(packetClass);
        if (vanillaClass == null) {
            return null;
        }
        Object playProtocol = ConnectionProtocolAccessor.CONST_PLAY.get();
        Object outgoing = PacketFlowAccessor.CONST_CLIENTBOUND.get();
        if (ConnectionProtocolAccessor.FIELD_FLOWS.get() == null) {
            Object outgoingMap = Reflect.getFieldResulted(playProtocol, ConnectionProtocolAccessor.FIELD_PACKETS.get()).as(Map.class).get(outgoing);
            packetId = (Integer)Reflect.fastInvokeResulted(outgoingMap, "inverse").as(Map.class).get(vanillaClass);
        } else {
            Object outgoingMap = Reflect.getFieldResulted(playProtocol, ConnectionProtocolAccessor.FIELD_FLOWS.get()).as(Map.class).get(outgoing);
            if (ConnectionProtocol$CodecDataAccessor.TYPE.get() != null && ConnectionProtocol$CodecDataAccessor.TYPE.get().isInstance(outgoingMap)) {
                outgoingMap = Reflect.getField(outgoingMap, ConnectionProtocol$CodecDataAccessor.FIELD_PACKET_SET.get());
            }
            packetId = Reflect.fastInvokeResulted(outgoingMap, ConnectionProtocol$PacketSetAccessor.METHOD_GET_ID.get(), vanillaClass).as(Integer.class);
        }
        ID_CACHE.put(packetClass, packetId);
        return packetId;
    }

    @Generated
    private PacketIdMapping() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PacketIdMapping.putTranslateSafely(ClientboundAddEntityPacket.class, ClientboundAddEntityPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundAddMobPacket.class, ClientboundAddMobPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundAddPlayerPacket.class, ClientboundAddPlayerPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundMoveEntityPacket.Rot.class, ClientboundMoveEntityPacket$RotAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundMoveEntityPacket.Pos.class, ClientboundMoveEntityPacket$PosAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundMoveEntityPacket.PosRot.class, ClientboundMoveEntityPacket$PosRotAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundPlayerInfoPacket.class, ClientboundPlayerInfoUpdatePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundPlayerInfoPacket.PlayerInfoRemovePacket1_19_3.class, ClientboundPlayerInfoRemovePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundRemoveEntitiesPacket.class, ClientboundRemoveEntitiesPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundRemoveMobEffectPacket.class, ClientboundRemoveMobEffectPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundRotateHeadPacket.class, ClientboundRotateHeadPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetDisplayObjectivePacket.class, ClientboundSetDisplayObjectivePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetEntityDataPacket.class, ClientboundSetEntityDataPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetEntityMotionPacket.class, ClientboundSetEntityMotionPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetEquipmentPacket.class, ClientboundSetEquipmentPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetExperiencePacket.class, ClientboundSetExperiencePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetObjectivePacket.class, ClientboundSetObjectivePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetPlayerTeamPacket.class, ClientboundSetPlayerTeamPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetScorePacket.class, ClientboundSetScorePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundSetScorePacket.ClientboundResetScorePacket1_20_3.class, ClientboundResetScorePacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundTeleportEntityPacket.class, ClientboundTeleportEntityPacketAccessor.TYPE.get());
        PacketIdMapping.putTranslateSafely(ClientboundUpdateMobEffectPacket.class, ClientboundUpdateMobEffectPacketAccessor.TYPE.get());
    }
}

