/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.world;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.LocationHolder;
import sba.sl.b.BlockPlacement;
import sba.sl.b.BlockPlacements;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.w.Location;

@ProvidedService
@ApiStatus.Internal
public abstract class Locations {
    @NotNull
    protected final BidirectionalConverter<Location> converter = BidirectionalConverter.build().registerP2W(Location.class, e -> e).registerW2P(BlockPlacement.class, BlockPlacements::resolve);
    @Nullable
    private static Locations locations;

    public Locations() {
        if (locations != null) {
            throw new UnsupportedOperationException("Locations is already initialized.");
        }
        locations = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Location resolve(@Nullable Object obj) {
        if (locations == null) {
            throw new UnsupportedOperationException("Locations is not initialized yet.");
        }
        return Locations.locations.converter.convertNullable(obj);
    }

    @NotNull
    public static <T> Location wrapLocation(@NotNull T input) {
        return Objects.requireNonNull(Locations.resolve(input));
    }

    public static <T> T convert(@NotNull Location holder, @NotNull Class<T> newType) {
        if (locations == null) {
            throw new UnsupportedOperationException("Locations is not initialized yet.");
        }
        return Locations.locations.converter.convert(holder, newType);
    }

    static {
        LocationHolder.Provider.registerProvider(Locations::wrapLocation);
    }
}

