/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.minitag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.Node;
import sba.sl.minitag.nodes.RootNode;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.minitag.nodes.TextNode;
import sba.sl.minitag.tags.RegisteredTag;
import sba.sl.minitag.tags.StandardTag;
import sba.sl.minitag.tags.TagType;
import sba.sl.minitag.tags.TransformedTag;

public class MiniTagParser {
    public static final char ESCAPE_SYMBOL = '\\';
    public static final char TAG_OPENING_SYMBOL = '<';
    public static final char TAG_CLOSING_SYMBOL = '>';
    public static final char ENDING_TAG_SYMBOL = '/';
    public static final char QUOTE = '\"';
    public static final char ALTERNATE_QUOTE = '\'';
    public static final char ARGUMENT_SEPARATOR = ':';
    @NotNull
    public static final String RESET_TAG = "reset";
    @NotNull
    public static final String PRE_TAG = "pre";
    @NotNull
    public static final TagType UNKNOWN_TAG_TYPE = TagType.SINGLE;
    private final boolean strictClosing;
    private final boolean escapeInvalidEndings;
    @Nullable
    private final String preTag;
    @Nullable
    private final String resetTag;
    @NotNull
    private final TagType unknownTagType;
    private final char escapeSymbol;
    private final char tagOpeningSymbol;
    private final char tagClosingSymbol;
    private final char endingTagSymbol;
    private final char argumentSeparator;
    @NotNull
    private final @NotNull List<@NotNull Character> quotes;
    @NotNull
    private final @NotNull Map<@NotNull String, RegisteredTag> registeredTags;
    @NotNull
    private final @NotNull Map<@NotNull Pattern, RegisteredTag> registeredRegexTags;

    @NotNull
    public RootNode parse(@NotNull String tag) {
        String text;
        char[] chars = tag.toCharArray();
        RootNode root = new RootNode();
        boolean escaped = false;
        boolean tagOpened = false;
        boolean inQuotes = false;
        boolean inPre = false;
        char usedQuote = '\"';
        StringBuilder builder = new StringBuilder();
        NodeCursor cursor = new NodeCursor(null, root);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (inPre) {
                builder.append(c);
                if (!builder.toString().endsWith("" + this.tagOpeningSymbol + this.endingTagSymbol + this.preTag + this.tagClosingSymbol)) continue;
                builder.setLength(builder.length() - 3 - this.preTag.length());
                inPre = false;
                continue;
            }
            if (escaped) {
                builder.append(c);
                escaped = false;
                continue;
            }
            if (c == this.escapeSymbol) {
                if (tagOpened) {
                    builder.append(c);
                }
                escaped = true;
                continue;
            }
            if (tagOpened) {
                if (inQuotes) {
                    builder.append(c);
                    if (c != usedQuote) continue;
                    inQuotes = false;
                    continue;
                }
                if (c == this.tagClosingSymbol) {
                    TagType tagType;
                    String tagString = builder.toString();
                    builder.setLength(0);
                    tagOpened = false;
                    if (tagString.equals(this.resetTag)) {
                        cursor = new NodeCursor(null, root);
                        continue;
                    }
                    if (tagString.equals(this.preTag)) {
                        inPre = true;
                        continue;
                    }
                    if (tagString.charAt(0) == this.endingTagSymbol) {
                        String shortTs;
                        String stripped = tagString.substring(1);
                        if (!(cursor.node instanceof TagNode)) {
                            if (this.escapeInvalidEndings) {
                                cursor.node.putChildren(new TextNode(this.tagOpeningSymbol + tagString + this.tagClosingSymbol));
                                continue;
                            }
                            throw new IllegalArgumentException("Illegal ending tag " + this.tagOpeningSymbol + tagString + this.tagClosingSymbol + " (position " + i + "): No tag is opened");
                        }
                        String ts = ((TagNode)cursor.node).getTag();
                        String originalShortTs = shortTs = ts.split(String.valueOf(this.argumentSeparator))[0];
                        if (!ts.equals(stripped) && !shortTs.equals(stripped)) {
                            if (this.strictClosing) {
                                if (this.escapeInvalidEndings) {
                                    cursor.node.putChildren(new TextNode(this.tagOpeningSymbol + tagString + this.tagClosingSymbol));
                                    continue;
                                }
                                throw new IllegalArgumentException("Illegal ending tag " + this.tagOpeningSymbol + tagString + this.tagClosingSymbol + " (position " + i + "): Wrong tag is closed! Should be " + this.tagOpeningSymbol + this.endingTagSymbol + shortTs + this.tagClosingSymbol);
                            }
                            do {
                                NodeCursor parent;
                                if ((parent = cursor.cursor) != null && parent.node instanceof TagNode) {
                                    cursor = parent;
                                    ts = ((TagNode)cursor.node).getTag();
                                    shortTs = ts.split(String.valueOf(this.argumentSeparator))[0];
                                    continue;
                                }
                                if (this.escapeInvalidEndings) {
                                    cursor.node.putChildren(new TextNode(this.tagOpeningSymbol + tagString + this.tagClosingSymbol));
                                    continue;
                                }
                                throw new IllegalArgumentException("Illegal ending tag " + this.tagOpeningSymbol + tagString + this.tagClosingSymbol + " (position " + i + "): Wrong tag is closed! Should be " + this.tagOpeningSymbol + this.endingTagSymbol + originalShortTs + this.tagClosingSymbol);
                            } while (!ts.equals(stripped) && !shortTs.equals(stripped));
                        }
                        assert (cursor.cursor != null);
                        cursor = cursor.cursor;
                        continue;
                    }
                    boolean single = false;
                    if (tagString.charAt(tagString.length() - 1) == this.endingTagSymbol) {
                        single = true;
                        tagString = tagString.substring(0, tagString.length() - 1);
                    }
                    TagNode tagNode = this.readTag(tagString);
                    cursor.node.putChildren(tagNode);
                    if (single) continue;
                    RegisteredTag register = this.registeredTags.get(tagNode.getTag());
                    if (register == null && !this.registeredRegexTags.isEmpty()) {
                        register = this.registeredRegexTags.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(tagNode.getTag()).matches()).map(Map.Entry::getValue).findFirst().orElse(null);
                    }
                    TagType tagType2 = tagType = register != null ? register.tagType() : this.unknownTagType;
                    if (tagType != TagType.PAIR) continue;
                    cursor = new NodeCursor(cursor, tagNode);
                    continue;
                }
                if (this.quotes.contains(Character.valueOf(c))) {
                    inQuotes = true;
                    usedQuote = c;
                    builder.append(c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == this.tagOpeningSymbol && i != chars.length - 1 && chars[i + 1] != this.tagClosingSymbol && chars[i + 1] != this.tagOpeningSymbol) {
                String text2 = builder.toString();
                if (!text2.isEmpty()) {
                    cursor.node.putChildren(new TextNode(builder.toString()));
                }
                builder.setLength(0);
                tagOpened = true;
                continue;
            }
            builder.append(c);
        }
        if (escaped) {
            builder.append("\\");
        }
        if (!(text = builder.toString()).isEmpty()) {
            cursor.node.putChildren(new TextNode(builder.toString()));
        }
        this.mergeTextChildren(root);
        return this.transformAliases(root);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public RootNode newRoot() {
        return new RootNode();
    }

    @NotNull
    public String serialize(@NotNull RootNode root) {
        StringBuilder builder = new StringBuilder();
        this.serializeChildren(builder, root.children(), true);
        return builder.toString();
    }

    @NotNull
    private @NotNull List<@NotNull TagNode> serializeChildren(@NotNull StringBuilder builder, @NotNull @NotNull List<@NotNull Node> children, boolean top) {
        ArrayList<TagNode> stillOpenedTags = new ArrayList<TagNode>();
        for (int a = 0; a < children.size(); ++a) {
            Object lastTag;
            Node child = children.get(a);
            if (!stillOpenedTags.isEmpty()) {
                if (top && this.resetTag != null) {
                    builder.append(this.tagOpeningSymbol).append(this.resetTag).append(this.tagClosingSymbol);
                } else {
                    lastTag = stillOpenedTags.get(stillOpenedTags.size() - 1);
                    if (stillOpenedTags.size() == 1) {
                        builder.append(this.tagOpeningSymbol).append(this.endingTagSymbol).append(((TagNode)lastTag).getTag()).append(this.tagClosingSymbol);
                    } else {
                        int sameName = 0;
                        int sameArgs = 0;
                        for (int i = 0; i < stillOpenedTags.size() - 1; ++i) {
                            TagNode tag = stillOpenedTags.get(i);
                            if (!tag.getTag().equals(((TagNode)lastTag).getTag())) continue;
                            sameName = 1;
                            if (!tag.getArgs().equals(((TagNode)lastTag).getArgs())) continue;
                            sameArgs = 1;
                            break;
                        }
                        if (sameArgs != 0) {
                            for (TagNode tag : stillOpenedTags) {
                                builder.append(this.tagOpeningSymbol).append(this.endingTagSymbol).append(tag.getTag()).append(this.tagClosingSymbol);
                            }
                        } else if (sameName != 0) {
                            builder.append(this.tagOpeningSymbol).append(this.endingTagSymbol).append(((TagNode)lastTag).getTag());
                            for (String arg : ((TagNode)lastTag).getArgs()) {
                                builder.append(this.argumentSeparator);
                                if (arg.indexOf(this.tagOpeningSymbol) != -1 || arg.indexOf(this.tagClosingSymbol) != -1 || arg.indexOf(this.escapeSymbol) != -1 || arg.indexOf(this.argumentSeparator) != -1 || arg.indexOf(this.endingTagSymbol) != -1 || this.quotes.stream().anyMatch(c -> arg.indexOf(c.charValue()) != -1)) {
                                    Character usedQuote = this.quotes.get(0);
                                    builder.append(usedQuote);
                                    for (char c2 : arg.toCharArray()) {
                                        if (c2 == usedQuote.charValue() || c2 == this.escapeSymbol) {
                                            builder.append(this.escapeSymbol);
                                        }
                                        builder.append(c2);
                                    }
                                    builder.append(usedQuote);
                                    continue;
                                }
                                builder.append(arg);
                            }
                            builder.append(this.tagClosingSymbol);
                        } else {
                            builder.append(this.tagOpeningSymbol).append(this.endingTagSymbol).append(((TagNode)lastTag).getTag()).append(this.tagClosingSymbol);
                        }
                    }
                }
                stillOpenedTags.clear();
            }
            if (child instanceof TextNode) {
                for (char c3 : ((TextNode)child).getText().toCharArray()) {
                    if (c3 == this.tagOpeningSymbol) {
                        builder.append(this.escapeSymbol);
                    }
                    builder.append(c3);
                }
                continue;
            }
            if (child instanceof TagNode) {
                builder.append(this.tagOpeningSymbol).append(((TagNode)child).getTag());
                lastTag = ((TagNode)child).getArgs().iterator();
                while (lastTag.hasNext()) {
                    String arg = (String)lastTag.next();
                    builder.append(this.argumentSeparator);
                    if (arg.indexOf(this.tagOpeningSymbol) != -1 || arg.indexOf(this.tagClosingSymbol) != -1 || arg.indexOf(this.escapeSymbol) != -1 || arg.indexOf(this.argumentSeparator) != -1 || arg.indexOf(this.endingTagSymbol) != -1 || this.quotes.stream().anyMatch(c -> arg.indexOf(c.charValue()) != -1)) {
                        Character usedQuote = this.quotes.get(0);
                        builder.append(usedQuote);
                        for (char c4 : arg.toCharArray()) {
                            if (c4 == usedQuote.charValue() || c4 == this.escapeSymbol) {
                                builder.append(this.escapeSymbol);
                            }
                            builder.append(c4);
                        }
                        builder.append(usedQuote);
                        continue;
                    }
                    builder.append(arg);
                }
                if (!(child.hasChildren() || !this.strictClosing && top && a + 1 == children.size())) {
                    builder.append(this.endingTagSymbol);
                }
                builder.append(this.tagClosingSymbol);
                if (!child.hasChildren()) continue;
                List<TagNode> stillOpenedTagsChild = this.serializeChildren(builder, child.children(), false);
                if (this.strictClosing) {
                    builder.append(this.tagOpeningSymbol).append(this.endingTagSymbol).append(((TagNode)child).getTag()).append(this.tagClosingSymbol);
                    continue;
                }
                stillOpenedTags.addAll(stillOpenedTagsChild);
                stillOpenedTags.add((TagNode)child);
                continue;
            }
            throw new IllegalArgumentException("Invalid node type: " + child.getClass().getName());
        }
        return stillOpenedTags;
    }

    @NotNull
    private TagNode readTag(@NotNull String tag) {
        if (!tag.contains(":")) {
            return new TagNode(tag, List.of());
        }
        char[] chars = tag.toCharArray();
        boolean escaped = false;
        boolean inQuotes = false;
        char usedQuote = '\"';
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char c : chars) {
            if (escaped) {
                builder.append(c);
                escaped = false;
                continue;
            }
            if (c == this.escapeSymbol) {
                escaped = true;
                continue;
            }
            if (inQuotes) {
                if (c == usedQuote) {
                    inQuotes = false;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == this.argumentSeparator) {
                arguments.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (builder.length() == 0 && this.quotes.contains(Character.valueOf(c))) {
                inQuotes = true;
                usedQuote = c;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() != 0) {
            arguments.add(builder.toString());
        }
        String name = (String)arguments.get(0);
        arguments.remove(0);
        return new TagNode(name, arguments);
    }

    private void mergeTextChildren(@NotNull Node node) {
        if (node.children().isEmpty()) {
            return;
        }
        if (node.children().size() == 1) {
            Node onlyNode = node.children().get(0);
            if (!(onlyNode instanceof TextNode)) {
                this.mergeTextChildren(onlyNode);
            }
            return;
        }
        List<Node> children = List.copyOf(node.children());
        node.children().clear();
        StringBuilder builder = new StringBuilder();
        for (Node child : children) {
            if (child instanceof TextNode) {
                builder.append(((TextNode)child).getText());
                continue;
            }
            if (builder.length() != 0) {
                node.putChildren(new TextNode(builder.toString()));
                builder.setLength(0);
            }
            node.putChildren(child);
            this.mergeTextChildren(child);
        }
        if (builder.length() != 0) {
            node.putChildren(new TextNode(builder.toString()));
            builder.setLength(0);
        }
    }

    @NotNull
    private <T extends Node> T transformAliases(@NotNull T node) {
        List<Node> children = List.copyOf(node.children());
        node.children().clear();
        if (node instanceof TagNode) {
            RegisteredTag registeredTag = this.registeredTags.get(((TagNode)node).getTag());
            if (registeredTag instanceof TransformedTag) {
                node = ((TransformedTag)registeredTag).transformer().transform((TagNode)node);
            } else {
                TagNode finalNode = (TagNode)node;
                Optional<RegisteredTag> registeredRegexTag = this.registeredRegexTags.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(finalNode.getTag()).matches()).map(Map.Entry::getValue).findFirst();
                if (registeredRegexTag.isPresent() && registeredRegexTag.get() instanceof TransformedTag) {
                    node = ((TransformedTag)registeredRegexTag.get()).transformer().transform((TagNode)node);
                }
            }
        }
        if (!children.isEmpty()) {
            for (Node child : children) {
                node.putChildren(this.transformAliases(child));
            }
        }
        return node;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public MiniTagParser(boolean strictClosing, boolean escapeInvalidEndings, @Nullable String preTag, @Nullable String resetTag, @NotNull TagType unknownTagType, char escapeSymbol, char tagOpeningSymbol, char tagClosingSymbol, char endingTagSymbol, char argumentSeparator, @NotNull @NotNull List<@NotNull Character> quotes, @NotNull @NotNull Map<@NotNull String, RegisteredTag> registeredTags, @NotNull @NotNull Map<@NotNull Pattern, RegisteredTag> registeredRegexTags) {
        if (unknownTagType == null) {
            throw new NullPointerException("unknownTagType is marked non-null but is null");
        }
        if (quotes == null) {
            throw new NullPointerException("quotes is marked non-null but is null");
        }
        if (registeredTags == null) {
            throw new NullPointerException("registeredTags is marked non-null but is null");
        }
        if (registeredRegexTags == null) {
            throw new NullPointerException("registeredRegexTags is marked non-null but is null");
        }
        this.strictClosing = strictClosing;
        this.escapeInvalidEndings = escapeInvalidEndings;
        this.preTag = preTag;
        this.resetTag = resetTag;
        this.unknownTagType = unknownTagType;
        this.escapeSymbol = escapeSymbol;
        this.tagOpeningSymbol = tagOpeningSymbol;
        this.tagClosingSymbol = tagClosingSymbol;
        this.endingTagSymbol = endingTagSymbol;
        this.argumentSeparator = argumentSeparator;
        this.quotes = quotes;
        this.registeredTags = registeredTags;
        this.registeredRegexTags = registeredRegexTags;
    }

    @Generated
    public boolean strictClosing() {
        return this.strictClosing;
    }

    @Generated
    public boolean escapeInvalidEndings() {
        return this.escapeInvalidEndings;
    }

    @Nullable
    @Generated
    public String preTag() {
        return this.preTag;
    }

    @Nullable
    @Generated
    public String resetTag() {
        return this.resetTag;
    }

    @NotNull
    @Generated
    public TagType unknownTagType() {
        return this.unknownTagType;
    }

    @Generated
    public char escapeSymbol() {
        return this.escapeSymbol;
    }

    @Generated
    public char tagOpeningSymbol() {
        return this.tagOpeningSymbol;
    }

    @Generated
    public char tagClosingSymbol() {
        return this.tagClosingSymbol;
    }

    @Generated
    public char endingTagSymbol() {
        return this.endingTagSymbol;
    }

    @Generated
    public char argumentSeparator() {
        return this.argumentSeparator;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull Character> quotes() {
        return this.quotes;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull String, RegisteredTag> registeredTags() {
        return this.registeredTags;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull Pattern, RegisteredTag> registeredRegexTags() {
        return this.registeredRegexTags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MiniTagParser)) {
            return false;
        }
        MiniTagParser other = (MiniTagParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.strictClosing() != other.strictClosing()) {
            return false;
        }
        if (this.escapeInvalidEndings() != other.escapeInvalidEndings()) {
            return false;
        }
        if (this.escapeSymbol() != other.escapeSymbol()) {
            return false;
        }
        if (this.tagOpeningSymbol() != other.tagOpeningSymbol()) {
            return false;
        }
        if (this.tagClosingSymbol() != other.tagClosingSymbol()) {
            return false;
        }
        if (this.endingTagSymbol() != other.endingTagSymbol()) {
            return false;
        }
        if (this.argumentSeparator() != other.argumentSeparator()) {
            return false;
        }
        String this$preTag = this.preTag();
        String other$preTag = other.preTag();
        if (this$preTag == null ? other$preTag != null : !this$preTag.equals(other$preTag)) {
            return false;
        }
        String this$resetTag = this.resetTag();
        String other$resetTag = other.resetTag();
        if (this$resetTag == null ? other$resetTag != null : !this$resetTag.equals(other$resetTag)) {
            return false;
        }
        TagType this$unknownTagType = this.unknownTagType();
        TagType other$unknownTagType = other.unknownTagType();
        if (this$unknownTagType == null ? other$unknownTagType != null : !((Object)((Object)this$unknownTagType)).equals((Object)other$unknownTagType)) {
            return false;
        }
        List<Character> this$quotes = this.quotes();
        List<Character> other$quotes = other.quotes();
        if (this$quotes == null ? other$quotes != null : !((Object)this$quotes).equals(other$quotes)) {
            return false;
        }
        Map<String, RegisteredTag> this$registeredTags = this.registeredTags();
        Map<String, RegisteredTag> other$registeredTags = other.registeredTags();
        if (this$registeredTags == null ? other$registeredTags != null : !((Object)this$registeredTags).equals(other$registeredTags)) {
            return false;
        }
        Map<Pattern, RegisteredTag> this$registeredRegexTags = this.registeredRegexTags();
        Map<Pattern, RegisteredTag> other$registeredRegexTags = other.registeredRegexTags();
        return !(this$registeredRegexTags == null ? other$registeredRegexTags != null : !((Object)this$registeredRegexTags).equals(other$registeredRegexTags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MiniTagParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.strictClosing() ? 79 : 97);
        result = result * 59 + (this.escapeInvalidEndings() ? 79 : 97);
        result = result * 59 + this.escapeSymbol();
        result = result * 59 + this.tagOpeningSymbol();
        result = result * 59 + this.tagClosingSymbol();
        result = result * 59 + this.endingTagSymbol();
        result = result * 59 + this.argumentSeparator();
        String $preTag = this.preTag();
        result = result * 59 + ($preTag == null ? 43 : $preTag.hashCode());
        String $resetTag = this.resetTag();
        result = result * 59 + ($resetTag == null ? 43 : $resetTag.hashCode());
        TagType $unknownTagType = this.unknownTagType();
        result = result * 59 + ($unknownTagType == null ? 43 : ((Object)((Object)$unknownTagType)).hashCode());
        List<Character> $quotes = this.quotes();
        result = result * 59 + ($quotes == null ? 43 : ((Object)$quotes).hashCode());
        Map<String, RegisteredTag> $registeredTags = this.registeredTags();
        result = result * 59 + ($registeredTags == null ? 43 : ((Object)$registeredTags).hashCode());
        Map<Pattern, RegisteredTag> $registeredRegexTags = this.registeredRegexTags();
        result = result * 59 + ($registeredRegexTags == null ? 43 : ((Object)$registeredRegexTags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MiniTagParser(strictClosing=" + this.strictClosing() + ", escapeInvalidEndings=" + this.escapeInvalidEndings() + ", preTag=" + this.preTag() + ", resetTag=" + this.resetTag() + ", unknownTagType=" + String.valueOf((Object)this.unknownTagType()) + ", escapeSymbol=" + this.escapeSymbol() + ", tagOpeningSymbol=" + this.tagOpeningSymbol() + ", tagClosingSymbol=" + this.tagClosingSymbol() + ", endingTagSymbol=" + this.endingTagSymbol() + ", argumentSeparator=" + this.argumentSeparator() + ", quotes=" + String.valueOf(this.quotes()) + ", registeredTags=" + String.valueOf(this.registeredTags()) + ", registeredRegexTags=" + String.valueOf(this.registeredRegexTags()) + ")";
    }

    private static class NodeCursor {
        @Nullable
        private final NodeCursor cursor;
        @NotNull
        private final Node node;

        @Generated
        public NodeCursor(@Nullable NodeCursor cursor, @NotNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            this.cursor = cursor;
            this.node = node;
        }
    }

    public static class Builder {
        private boolean strictClosing = true;
        private boolean escapeInvalidEndings;
        @Nullable
        private String preTag;
        @Nullable
        private String resetTag = "reset";
        @NotNull
        private TagType unknownTagType = UNKNOWN_TAG_TYPE;
        private char escapeSymbol = (char)92;
        private char tagOpeningSymbol = (char)60;
        private char tagClosingSymbol = (char)62;
        private char endingTagSymbol = (char)47;
        private char argumentSeparator = (char)58;
        @NotNull
        private @NotNull List<@NotNull Character> quotes = List.of(Character.valueOf('\"'), Character.valueOf('\''));
        @NotNull
        private final @NotNull Map<@NotNull String, RegisteredTag> registeredTags = new HashMap<String, RegisteredTag>();
        @NotNull
        private final @NotNull Map<@NotNull Pattern, RegisteredTag> registeredRegexTags = new HashMap<Pattern, RegisteredTag>();

        @Contract(value="_ -> this")
        @NotNull
        public Builder preTag(boolean enablePreTag) {
            this.preTag = enablePreTag ? MiniTagParser.PRE_TAG : null;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder resetTag(boolean enableResetTag) {
            this.resetTag = enableResetTag ? MiniTagParser.RESET_TAG : null;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder quotes(Character ... quotes) {
            this.quotes = List.of(quotes);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull String tag, @NotNull RegisteredTag registeredTag) {
            this.registeredTags.put(tag, registeredTag);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull Pattern tag, @NotNull RegisteredTag registeredTag) {
            this.registeredRegexTags.put(tag, registeredTag);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull String tag, @NotNull TagType type) {
            this.registeredTags.put(tag, new StandardTag(type));
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull Pattern tag, @NotNull TagType type) {
            this.registeredRegexTags.put(tag, new StandardTag(type));
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull String tag, @NotNull RegisteredTag registeredTag, String ... aliases) {
            this.registeredTags.put(tag, registeredTag);
            for (String alias : aliases) {
                if (registeredTag instanceof TransformedTag) {
                    this.registeredTags.put(alias, new TransformedTag(registeredTag.tagType(), node -> ((TransformedTag)registeredTag).transformer().transform(new TagNode(tag, node.getArgs()))));
                    continue;
                }
                this.registeredTags.put(alias, new TransformedTag(registeredTag.tagType(), node -> new TagNode(tag, node.getArgs())));
            }
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder registerTag(@NotNull String tag, @NotNull TagType type, String ... aliases) {
            this.registeredTags.put(tag, new StandardTag(type));
            for (String alias : aliases) {
                this.registeredTags.put(alias, new TransformedTag(type, node -> new TagNode(tag, node.getArgs())));
            }
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public MiniTagParser build() {
            return new MiniTagParser(this.strictClosing, this.escapeInvalidEndings, this.preTag, this.resetTag, this.unknownTagType, this.escapeSymbol, this.tagOpeningSymbol, this.tagClosingSymbol, this.endingTagSymbol, this.argumentSeparator, this.quotes, Map.copyOf(this.registeredTags), Map.copyOf(this.registeredRegexTags));
        }

        @Generated
        public Builder strictClosing(boolean strictClosing) {
            this.strictClosing = strictClosing;
            return this;
        }

        @Generated
        public Builder escapeInvalidEndings(boolean escapeInvalidEndings) {
            this.escapeInvalidEndings = escapeInvalidEndings;
            return this;
        }

        @Generated
        public Builder preTag(@Nullable String preTag) {
            this.preTag = preTag;
            return this;
        }

        @Generated
        public Builder resetTag(@Nullable String resetTag) {
            this.resetTag = resetTag;
            return this;
        }

        @Generated
        public Builder unknownTagType(@NotNull TagType unknownTagType) {
            if (unknownTagType == null) {
                throw new NullPointerException("unknownTagType is marked non-null but is null");
            }
            this.unknownTagType = unknownTagType;
            return this;
        }

        @Generated
        public Builder escapeSymbol(char escapeSymbol) {
            this.escapeSymbol = escapeSymbol;
            return this;
        }

        @Generated
        public Builder tagOpeningSymbol(char tagOpeningSymbol) {
            this.tagOpeningSymbol = tagOpeningSymbol;
            return this;
        }

        @Generated
        public Builder tagClosingSymbol(char tagClosingSymbol) {
            this.tagClosingSymbol = tagClosingSymbol;
            return this;
        }

        @Generated
        public Builder endingTagSymbol(char endingTagSymbol) {
            this.endingTagSymbol = endingTagSymbol;
            return this;
        }

        @Generated
        public Builder argumentSeparator(char argumentSeparator) {
            this.argumentSeparator = argumentSeparator;
            return this;
        }

        @Generated
        public Builder quotes(@NotNull @NotNull List<@NotNull Character> quotes) {
            if (quotes == null) {
                throw new NullPointerException("quotes is marked non-null but is null");
            }
            this.quotes = quotes;
            return this;
        }
    }
}

