/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.Tag;

public final class ByteTag
implements Tag,
NumericTag {
    @NotNull
    public static final ByteTag TRUE = new ByteTag(1);
    @NotNull
    public static final ByteTag FALSE = new ByteTag(0);
    private final byte value;

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public boolean canHoldDataOfTag(@NotNull NumericTag tag) {
        return tag instanceof ByteTag || tag.longValue() <= 127L && tag.longValue() >= -128L;
    }

    @Override
    @NotNull
    public NumericTag convert(@NotNull NumericTag tag) {
        return new ByteTag(tag.byteValue());
    }

    @Generated
    public ByteTag(byte value) {
        this.value = value;
    }

    @Generated
    public byte value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteTag)) {
            return false;
        }
        ByteTag other = (ByteTag)o;
        return this.value() == other.value();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.value();
        return result;
    }

    @Generated
    public String toString() {
        return "ByteTag(value=" + this.value() + ")";
    }
}

