/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CollectionTag;
import sba.sl.nbt.CompoundTagModifier;
import sba.sl.nbt.CompoundTagTreeInspector;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.nbt.TreeInspectorKey;

public final class CompoundTag
implements Tag,
CompoundTagTreeInspector,
CompoundTagModifier {
    @NotNull
    private static final String WRAPPER_KEY = "";
    @NotNull
    public static final CompoundTag EMPTY = new CompoundTag(Map.of());
    @NotNull
    private final @NotNull Map<@NotNull String, Tag> value;

    @NotNull
    public static CompoundTag wrapper(@NotNull Tag tag) {
        if (tag instanceof CompoundTag) {
            throw new IllegalArgumentException("Cannot wrap a CompoundTag");
        }
        return new CompoundTag(Map.of(WRAPPER_KEY, tag));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public @NotNull Map<@NotNull String, Tag> value() {
        return Map.copyOf(this.value);
    }

    public boolean hasTag(@NotNull String name) {
        return this.value.containsKey(name);
    }

    @Nullable
    public Tag tag(@NotNull String name) {
        return this.value.get(name);
    }

    public boolean isTagWrapper() {
        return this.value.size() == 1 && this.value.containsKey(WRAPPER_KEY);
    }

    @Nullable
    public Tag wrappedTag() {
        if (this.isTagWrapper()) {
            return this.value.get(WRAPPER_KEY);
        }
        return null;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, @NotNull Tag tag) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, tag);
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, boolean value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, value ? ByteTag.TRUE : ByteTag.FALSE);
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, byte @NotNull [] value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new ByteArrayTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, byte value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new ByteTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, @NotNull @NotNull Map<@NotNull String, Tag> value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new CompoundTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, double value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new DoubleTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, float value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new FloatTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, int @NotNull [] value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new IntArrayTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, int value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new IntTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, @NotNull @NotNull List<? extends @NotNull Tag> value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new ListTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, long @NotNull [] value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new LongArrayTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, long value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new LongTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, short value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new ShortTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public CompoundTag with(@NotNull String name, @NotNull String value) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.put(name, new StringTag(value));
        return new CompoundTag(clone);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public CompoundTag without(@NotNull String name) {
        HashMap<String, Tag> clone = new HashMap<String, Tag>(this.value);
        clone.remove(name);
        return new CompoundTag(clone);
    }

    public void forEach(@NotNull @NotNull BiConsumer<@NotNull String, @NotNull Tag> consumer) {
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @NotNull
    public @NotNull Stream<@NotNull Map.Entry<@NotNull String, @NotNull Tag>> stream() {
        return this.value.entrySet().stream();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public int size() {
        return this.value.size();
    }

    @Override
    @Nullable
    public Tag findTag(String ... tagKeys) {
        if (tagKeys.length == 0) {
            return null;
        }
        if (tagKeys.length == 1) {
            return this.tag(tagKeys[0]);
        }
        @Nullable Tag currentTag = this;
        for (String key : tagKeys) {
            if (currentTag instanceof CompoundTag) {
                currentTag = currentTag.tag(key);
                continue;
            }
            if (currentTag instanceof CollectionTag) {
                try {
                    int number;
                    if (key.startsWith("[")) {
                        key = key.substring(1);
                    }
                    if (key.endsWith("]")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if ((number = Integer.parseInt(key)) < ((CollectionTag)currentTag).size()) {
                        currentTag = ((CollectionTag)currentTag).getAsTag(number);
                        continue;
                    }
                    currentTag = null;
                }
                catch (Throwable throwable) {}
                continue;
            }
            return null;
        }
        return currentTag;
    }

    @Override
    @NotNull
    public CompoundTag with(@NotNull Tag tag, String ... tagKeys) {
        if (tagKeys.length == 0) {
            return this;
        }
        if (tagKeys.length == 1) {
            return this.with(tagKeys[0], tag);
        }
        return (CompoundTag)this.withInternal(this, tagKeys, 0, tag);
    }

    @Override
    @NotNull
    public <T extends Tag> CompoundTag with(@NotNull TreeInspectorKey<T> treeKey, @NotNull T tag) {
        String[] tagKeys = treeKey.getTagKeys();
        if (tagKeys.length == 0) {
            return this;
        }
        if (tagKeys.length == 1) {
            return this.with(tagKeys[0], tag);
        }
        return (CompoundTag)this.withInternal(this, tagKeys, 0, tag);
    }

    @NotNull
    private Tag withInternal(@NotNull Tag tag, @NotNull @NotNull String @NotNull [] tagKeys, int index, @NotNull Tag value) {
        if (index >= tagKeys.length) {
            return tag;
        }
        int relativeSize = tagKeys.length - index;
        if (tag instanceof CompoundTag) {
            if (relativeSize == 1) {
                return ((CompoundTag)tag).with(tagKeys[index], value);
            }
            Tag innerTag = ((CompoundTag)tag).tag(tagKeys[index]);
            if (innerTag != null) {
                if (innerTag instanceof CompoundTag || innerTag instanceof ListTag) {
                    return ((CompoundTag)tag).with(tagKeys[index], this.withInternal(innerTag, tagKeys, index + 1, value));
                }
                return tag;
            }
            boolean useList = false;
            String key = tagKeys[index + 1];
            if ("[]".equals(key)) {
                useList = true;
            } else {
                try {
                    if (key.startsWith("[")) {
                        key = key.substring(1);
                    }
                    if (key.endsWith("]")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    Integer.parseInt(key);
                    useList = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (useList) {
                return ((CompoundTag)tag).with(tagKeys[index], this.withInternal(ListTag.EMPTY, tagKeys, index + 1, value));
            }
            return ((CompoundTag)tag).with(tagKeys[index], this.withInternal(EMPTY, tagKeys, index + 1, value));
        }
        if (tag instanceof ListTag) {
            if (relativeSize == 1) {
                String key = tagKeys[index];
                if ("[]".equals(key)) {
                    return ((ListTag)tag).with(value);
                }
                try {
                    int number;
                    if (key.startsWith("[")) {
                        key = key.substring(1);
                    }
                    if (key.endsWith("]")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if ((number = Integer.parseInt(key)) < ((ListTag)tag).size()) {
                        return ((ListTag)tag).withAt(number, value);
                    }
                }
                catch (Throwable number) {
                    // empty catch block
                }
                return tag;
            }
            Tag innerTag = null;
            int numericIndex = -1;
            String thisKey = tagKeys[index];
            if (!"[]".equals(thisKey)) {
                try {
                    if (thisKey.startsWith("[")) {
                        thisKey = thisKey.substring(1);
                    }
                    if (thisKey.endsWith("]")) {
                        thisKey = thisKey.substring(0, thisKey.length() - 1);
                    }
                    if ((numericIndex = Integer.parseInt(thisKey)) >= ((ListTag)tag).size()) {
                        return tag;
                    }
                    innerTag = ((ListTag)tag).getAsTag(index);
                }
                catch (Throwable ignored) {
                    return tag;
                }
            }
            if (innerTag != null) {
                if (innerTag instanceof CompoundTag || innerTag instanceof ListTag) {
                    if (numericIndex == -1) {
                        return ((ListTag)tag).with(this.withInternal(innerTag, tagKeys, index + 1, value));
                    }
                    return ((ListTag)tag).withAt(numericIndex, this.withInternal(innerTag, tagKeys, index + 1, value));
                }
                return tag;
            }
            boolean useList = false;
            String key = tagKeys[index + 1];
            if ("[]".equals(key)) {
                useList = true;
            } else {
                try {
                    if (key.startsWith("[")) {
                        key = key.substring(1);
                    }
                    if (key.endsWith("]")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    Integer.parseInt(key);
                    useList = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (useList) {
                return ((ListTag)tag).with(this.withInternal(ListTag.EMPTY, tagKeys, index + 1, value));
            }
            return ((ListTag)tag).with(this.withInternal(EMPTY, tagKeys, index + 1, value));
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompoundTag without(String ... tagKeys) {
        void var6_8;
        if (tagKeys.length == 0) {
            return this;
        }
        if (tagKeys.length == 1) {
            return this.without(tagKeys[0]);
        }
        @NotNull ArrayList<@NotNull Map.Entry<@NotNull String, @NotNull CompoundTag>> parents = new ArrayList<Map.Entry<String, CompoundTag>>();
        @Nullable Tag currentTag = this;
        String[] stringArray = tagKeys;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            block17: {
                String key = stringArray[var6_8];
                if (currentTag instanceof CompoundTag) {
                    parents.add(Map.entry(key, currentTag));
                    currentTag = currentTag.tag(key);
                } else if (currentTag instanceof ListTag) {
                    try {
                        int number;
                        if (key.startsWith("[")) {
                            key = key.substring(1);
                        }
                        if (key.endsWith("]")) {
                            key = key.substring(0, key.length() - 1);
                        }
                        if ((number = Integer.parseInt(key)) < ((ListTag)currentTag).size()) {
                            parents.add(Map.entry(key, currentTag));
                            currentTag = ((ListTag)currentTag).getAsTag(number);
                            break block17;
                        }
                        currentTag = null;
                    }
                    catch (Throwable throwable) {}
                } else {
                    return this;
                }
            }
            ++var6_8;
        }
        if (currentTag != null) {
            Collections.reverse(parents);
            Tag latestChild = currentTag;
            for (Map.Entry entry : parents) {
                if (entry.getValue() instanceof CompoundTag) {
                    latestChild = ((CompoundTag)entry.getValue()).with((String)entry.getKey(), latestChild);
                    continue;
                }
                if (!(entry.getValue() instanceof ListTag)) continue;
                try {
                    int number = Integer.parseInt((String)entry.getKey());
                    latestChild = ((ListTag)entry.getValue()).without(number);
                }
                catch (Throwable throwable) {}
            }
            return latestChild;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T extends Tag> CompoundTag without(@NotNull TreeInspectorKey<T> treeKey) {
        void var7_9;
        String[] tagKeys = treeKey.getTagKeys();
        if (tagKeys.length == 0) {
            return this;
        }
        if (tagKeys.length == 1) {
            if (treeKey.getTagClass().isInstance(this.value.get(tagKeys[0]))) {
                return this.without(tagKeys[0]);
            }
            return this;
        }
        @NotNull ArrayList<@NotNull Map.Entry<@NotNull String, @NotNull CompoundTag>> parents = new ArrayList<Map.Entry<String, CompoundTag>>();
        Tag currentTag = this;
        String[] stringArray = tagKeys;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            block18: {
                String key = stringArray[var7_9];
                if (currentTag instanceof CompoundTag) {
                    parents.add(Map.entry(key, currentTag));
                    currentTag = currentTag.tag(key);
                } else if (currentTag instanceof ListTag) {
                    try {
                        int number;
                        if (key.startsWith("[")) {
                            key = key.substring(1);
                        }
                        if (key.endsWith("]")) {
                            key = key.substring(0, key.length() - 1);
                        }
                        if ((number = Integer.parseInt(key)) < ((ListTag)currentTag).size()) {
                            parents.add(Map.entry(key, currentTag));
                            currentTag = ((ListTag)currentTag).getAsTag(number);
                            break block18;
                        }
                        currentTag = null;
                    }
                    catch (Throwable throwable) {}
                } else {
                    return this;
                }
            }
            ++var7_9;
        }
        if (currentTag != null && treeKey.getTagClass().isInstance(currentTag)) {
            Collections.reverse(parents);
            Tag latestChild = currentTag;
            for (Map.Entry entry : parents) {
                if (entry.getValue() instanceof CompoundTag) {
                    latestChild = ((CompoundTag)entry.getValue()).with((String)entry.getKey(), latestChild);
                    continue;
                }
                if (!(entry.getValue() instanceof ListTag)) continue;
                try {
                    int number = Integer.parseInt((String)entry.getKey());
                    latestChild = ((ListTag)entry.getValue()).without(number);
                }
                catch (Throwable throwable) {}
            }
            return latestChild;
        }
        return this;
    }

    @Generated
    public CompoundTag(@NotNull @NotNull Map<@NotNull String, Tag> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundTag)) {
            return false;
        }
        CompoundTag other = (CompoundTag)o;
        Map<String, Tag> this$value = this.value();
        Map<String, Tag> other$value = other.value();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Tag> $value = this.value();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CompoundTag(value=" + String.valueOf(this.value()) + ")";
    }
}

