/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.Tag;

public final class FloatTag
implements Tag,
NumericTag {
    private final float value;

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0f;
    }

    @Override
    public boolean canHoldDataOfTag(@NotNull NumericTag tag) {
        return tag instanceof ByteTag || tag instanceof ShortTag || tag instanceof IntTag || tag instanceof LongTag || tag instanceof FloatTag;
    }

    @Override
    @NotNull
    public NumericTag convert(@NotNull NumericTag tag) {
        return new FloatTag(tag.floatValue());
    }

    @Generated
    public FloatTag(float value) {
        this.value = value;
    }

    @Generated
    public float value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatTag)) {
            return false;
        }
        FloatTag other = (FloatTag)o;
        return Float.compare(this.value(), other.value()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.value());
        return result;
    }

    @Generated
    public String toString() {
        return "FloatTag(value=" + this.value() + ")";
    }
}

