/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.CollectionTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.Tag;

public final class IntArrayTag
implements CollectionTag,
Iterable<Integer> {
    private final int @NotNull [] value;

    @NotNull
    public String toString() {
        return "IntArrayTag(value=" + Arrays.toString(this.value) + ")";
    }

    public int get(int index) {
        return this.value[index];
    }

    @Override
    @NotNull
    public Tag getAsTag(int index) {
        return new IntTag(this.value[index]);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    public  @NotNull PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != IntArrayTag.this.value.length;
            }

            @Override
            public int nextInt() {
                return IntArrayTag.this.value[this.cursor++];
            }
        };
    }

    public  @NotNull Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.value);
    }

    public void forEachInt(@NotNull IntConsumer consumer) {
        for (int i : this.value) {
            consumer.accept(i);
        }
    }

    @NotNull
    public IntStream stream() {
        return IntStream.of(this.value);
    }

    @Generated
    public IntArrayTag(int @NotNull [] value) {
        this.value = value;
    }

    @Generated
    public int @NotNull [] value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntArrayTag)) {
            return false;
        }
        IntArrayTag other = (IntArrayTag)o;
        return Arrays.equals(this.value(), other.value());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.value());
        return result;
    }
}

