/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.CollectionTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.Tag;

public final class LongArrayTag
implements CollectionTag,
Iterable<Long> {
    private final long @NotNull [] value;

    @NotNull
    public String toString() {
        return "LongArrayTag(value=" + Arrays.toString(this.value) + ")";
    }

    public long get(int index) {
        return this.value[index];
    }

    @Override
    @NotNull
    public Tag getAsTag(int index) {
        return new LongTag(this.value[index]);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    public  @NotNull PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != LongArrayTag.this.value.length;
            }

            @Override
            public long nextLong() {
                return LongArrayTag.this.value[this.cursor++];
            }
        };
    }

    public  @NotNull Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.value);
    }

    public void forEachLong(@NotNull LongConsumer consumer) {
        for (long l : this.value) {
            consumer.accept(l);
        }
    }

    @NotNull
    public LongStream stream() {
        return LongStream.of(this.value);
    }

    @Generated
    public LongArrayTag(long @NotNull [] value) {
        this.value = value;
    }

    @Generated
    public long @NotNull [] value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongArrayTag)) {
            return false;
        }
        LongArrayTag other = (LongArrayTag)o;
        return Arrays.equals(this.value(), other.value());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.value());
        return result;
    }
}

