/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.npc.skin;

import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ScopedConfigurationNode;
import sba.c.loader.AbstractConfigurationLoader;
import sba.c.objectmapping.ConfigSerializable;
import sba.sl.u.config.JsonConfigurationLoaderBuilderSupplier;

@ConfigSerializable
public class NPCSkin {
    @NotNull
    private static final @NotNull Map<@NotNull String, NPCSkin> PLAYER_NAME_SKIN_CACHE = new ConcurrentHashMap<String, NPCSkin>();
    @NotNull
    private static final @NotNull Map<@NotNull UUID, NPCSkin> PLAYER_UUID_SKIN_CACHE = new ConcurrentHashMap<UUID, NPCSkin>();
    @NotNull
    private String value;
    @NotNull
    private String signature;

    public static @NotNull CompletableFuture<@Nullable NPCSkin> retrieveSkin(@NotNull String playerName) {
        return NPCSkin.retrieveSkin(playerName, false);
    }

    public static @NotNull CompletableFuture<@Nullable NPCSkin> retrieveSkin(@NotNull String playerName, boolean force) {
        try {
            return NPCSkin.retrieveSkin(UUID.fromString(playerName.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), force);
        }
        catch (Throwable ignored) {
            if (PLAYER_NAME_SKIN_CACHE.containsKey(playerName) && !force) {
                return CompletableFuture.completedFuture(PLAYER_NAME_SKIN_CACHE.get(playerName));
            }
            return CompletableFuture.supplyAsync(() -> {
                try {
                    ScopedConfigurationNode node = (ScopedConfigurationNode)((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)JsonConfigurationLoaderBuilderSupplier.INSTANCE.get()).url(new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName))).build().load();
                    String userUUID = node.node(new Object[]{"id"}).getString("");
                    NPCSkin skin = NPCSkin.retrieveSkin(UUID.fromString(userUUID.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), force).get();
                    if (skin != null) {
                        PLAYER_NAME_SKIN_CACHE.put(playerName, skin);
                    }
                    return skin;
                }
                catch (Throwable throwable) {
                    return null;
                }
            });
        }
    }

    public static @NotNull CompletableFuture<@Nullable NPCSkin> retrieveSkin(@NotNull UUID uuid) {
        return NPCSkin.retrieveSkin(uuid, false);
    }

    public static @NotNull CompletableFuture<@Nullable NPCSkin> retrieveSkin(@NotNull UUID uuid, boolean force) {
        if (PLAYER_UUID_SKIN_CACHE.containsKey(uuid) && !force) {
            return CompletableFuture.completedFuture(PLAYER_UUID_SKIN_CACHE.get(uuid));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ScopedConfigurationNode node2 = (ScopedConfigurationNode)((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)JsonConfigurationLoaderBuilderSupplier.INSTANCE.get()).url(new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString() + "?unsigned=false"))).build().load();
                ScopedConfigurationNode skinNode = node2.node(new Object[]{"properties"}).childrenList().stream().filter(property -> "textures".equalsIgnoreCase(property.node(new Object[]{"name"}).getString(""))).findFirst().orElseThrow();
                NPCSkin skin = new NPCSkin(Objects.requireNonNull(skinNode.node(new Object[]{"value"}).getString()), Objects.requireNonNull(skinNode.node(new Object[]{"signature"}).getString()));
                PLAYER_UUID_SKIN_CACHE.put(uuid, skin);
                return skin;
            }
            catch (Throwable throwable) {
                return null;
            }
        });
    }

    @Generated
    public NPCSkin(@NotNull String value, @NotNull String signature) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        this.value = value;
        this.signature = signature;
    }

    @Generated
    public NPCSkin() {
    }

    @NotNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @NotNull
    @Generated
    public String getSignature() {
        return this.signature;
    }
}

