/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddEntityPacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.MetadataItem;
import sba.sl.p.PacketMapper;
import sba.sl.p.PacketWriter;
import sba.sl.u.math.Vector3D;
import sba.sl.w.Location;

public class ClientboundAddPlayerPacket
extends AbstractPacket {
    private final int entityId;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Location location;
    @NotNull
    private final @NotNull List<@NotNull MetadataItem> metadata;

    @Override
    public void write(@NotNull PacketWriter writer) {
        if (writer.protocol() >= 764) {
            writer.setCancelled(true);
            ClientboundAddEntityPacket packet = ClientboundAddEntityPacket.builder().entityId(this.entityId).uuid(this.uuid).location(this.location).velocity(Vector3D.ZERO).typeId(PacketMapper.getPlayerTypeId()).headYaw((byte)(this.location.getYaw() * 256.0f / 360.0f)).build();
            writer.append(packet);
            if (!this.metadata.isEmpty()) {
                writer.append(ClientboundSetEntityDataPacket.builder().entityId(this.entityId).metadata(this.metadata).build());
            }
        }
        writer.writeVarInt(this.entityId);
        writer.writeUuid(this.uuid);
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        writer.writeByteRotation(this.location);
        if (writer.protocol() < 49) {
            writer.writeShort(0);
        }
        if (writer.protocol() >= 550) {
            if (!this.metadata.isEmpty()) {
                writer.append(ClientboundSetEntityDataPacket.builder().entityId(this.entityId).metadata(this.metadata).build());
            }
        } else {
            writer.writeDataWatcherCollection(this.metadata);
        }
    }

    @Generated
    private static List<@NotNull MetadataItem> $default$metadata() {
        return List.of();
    }

    @Generated
    ClientboundAddPlayerPacket(int entityId, @NotNull UUID uuid, @NotNull Location location, @NotNull @NotNull List<@NotNull MetadataItem> metadata) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.location = location;
        this.metadata = metadata;
    }

    @Generated
    public static ClientboundAddPlayerPacketBuilder builder() {
        return new ClientboundAddPlayerPacketBuilder();
    }

    @Generated
    public ClientboundAddPlayerPacketBuilder toBuilder() {
        return new ClientboundAddPlayerPacketBuilder().entityId(this.entityId).uuid(this.uuid).location(this.location).metadata(this.metadata);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddPlayerPacket)) {
            return false;
        }
        ClientboundAddPlayerPacket other = (ClientboundAddPlayerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        UUID this$uuid = this.uuid();
        UUID other$uuid = other.uuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        Location this$location = this.location();
        Location other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<MetadataItem> this$metadata = this.metadata();
        List<MetadataItem> other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddPlayerPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        UUID $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        Location $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<MetadataItem> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @NotNull
    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public Location location() {
        return this.location;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull MetadataItem> metadata() {
        return this.metadata;
    }

    @Generated
    public String toString() {
        return "ClientboundAddPlayerPacket(entityId=" + this.entityId() + ", uuid=" + String.valueOf(this.uuid()) + ", location=" + String.valueOf(this.location()) + ", metadata=" + String.valueOf(this.metadata()) + ")";
    }

    @Generated
    public static class ClientboundAddPlayerPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private UUID uuid;
        @Generated
        private Location location;
        @Generated
        private boolean metadata$set;
        @Generated
        private List<@NotNull MetadataItem> metadata$value;

        @Generated
        ClientboundAddPlayerPacketBuilder() {
        }

        @Generated
        public ClientboundAddPlayerPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundAddPlayerPacketBuilder uuid(@NotNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            this.uuid = uuid;
            return this;
        }

        @Generated
        public ClientboundAddPlayerPacketBuilder location(@NotNull Location location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
            return this;
        }

        @Generated
        public ClientboundAddPlayerPacketBuilder metadata(@NotNull @NotNull List<@NotNull MetadataItem> metadata) {
            if (metadata == null) {
                throw new NullPointerException("metadata is marked non-null but is null");
            }
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this;
        }

        @Generated
        public ClientboundAddPlayerPacket build() {
            List<@NotNull MetadataItem> metadata$value = this.metadata$value;
            if (!this.metadata$set) {
                metadata$value = ClientboundAddPlayerPacket.$default$metadata();
            }
            return new ClientboundAddPlayerPacket(this.entityId, this.uuid, this.location, metadata$value);
        }

        @Generated
        public String toString() {
            return "ClientboundAddPlayerPacket.ClientboundAddPlayerPacketBuilder(entityId=" + this.entityId + ", uuid=" + String.valueOf(this.uuid) + ", location=" + String.valueOf(this.location) + ", metadata$value=" + String.valueOf(this.metadata$value) + ")";
        }
    }
}

