/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.Collection;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.spectator.Component;
import sba.sl.u.Preconditions;

public class ClientboundSetPlayerTeamPacket
extends AbstractPacket {
    @NotNull
    private final String teamKey;
    @NotNull
    private final Mode mode;
    @Nullable
    private final Component displayName;
    private final boolean friendlyFire;
    private final boolean seeInvisible;
    @Nullable
    private final TagVisibility tagVisibility;
    @Nullable
    private final CollisionRule collisionRule;
    @Nullable
    private final TeamColor teamColor;
    @Nullable
    private Component teamPrefix;
    @Nullable
    private Component teamSuffix;
    private @Nullable Collection<@NotNull String> entities;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeSizedString(this.teamKey);
        writer.writeByte((byte)this.mode.ordinal());
        if (this.mode == Mode.CREATE || this.mode == Mode.UPDATE) {
            Preconditions.checkNotNull(this.displayName);
            Preconditions.checkNotNull(this.teamPrefix);
            Preconditions.checkNotNull(this.teamSuffix);
            Preconditions.checkNotNull(this.tagVisibility);
            Preconditions.checkNotNull(this.collisionRule);
            Preconditions.checkNotNull(this.teamColor);
            if (writer.protocol() >= 390) {
                writer.writeComponent(this.displayName);
            } else {
                writer.writeSizedString(this.displayName.toLegacy());
            }
            if (writer.protocol() < 352) {
                writer.writeSizedString(this.teamPrefix.toLegacy());
                writer.writeSizedString(this.teamSuffix.toLegacy());
            }
            writer.writeByte((byte)((this.friendlyFire ? 1 : 0) | (this.seeInvisible ? 2 : 0)));
            if (writer.protocol() >= 770) {
                writer.writeVarInt(this.tagVisibility.ordinal());
            } else {
                writer.writeSizedString(this.tagVisibility.enumName());
            }
            if (writer.protocol() >= 770) {
                writer.writeVarInt(this.collisionRule.ordinal());
            } else if (writer.protocol() > 70) {
                writer.writeSizedString(this.collisionRule.enumName());
            }
            if (writer.protocol() < 352) {
                writer.writeByte((byte)this.teamColor.ordinal());
            } else {
                writer.writeVarInt(this.teamColor.ordinal());
            }
            if (writer.protocol() >= 375) {
                writer.writeComponent(this.teamPrefix);
                writer.writeComponent(this.teamSuffix);
            }
        }
        if (this.mode == Mode.CREATE || this.mode == Mode.ADD_ENTITY || this.mode == Mode.REMOVE_ENTITY) {
            writer.writeStringCollection(this.entities);
        }
    }

    @Generated
    private static TeamColor $default$teamColor() {
        return TeamColor.BLACK;
    }

    @Generated
    ClientboundSetPlayerTeamPacket(@NotNull String teamKey, @NotNull Mode mode, @Nullable Component displayName, boolean friendlyFire, boolean seeInvisible, @Nullable TagVisibility tagVisibility, @Nullable CollisionRule collisionRule, @Nullable TeamColor teamColor, @Nullable Component teamPrefix, @Nullable Component teamSuffix, @Nullable Collection<@NotNull String> entities) {
        if (teamKey == null) {
            throw new NullPointerException("teamKey is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.teamKey = teamKey;
        this.mode = mode;
        this.displayName = displayName;
        this.friendlyFire = friendlyFire;
        this.seeInvisible = seeInvisible;
        this.tagVisibility = tagVisibility;
        this.collisionRule = collisionRule;
        this.teamColor = teamColor;
        this.teamPrefix = teamPrefix;
        this.teamSuffix = teamSuffix;
        this.entities = entities;
    }

    @Generated
    public static ClientboundSetPlayerTeamPacketBuilder builder() {
        return new ClientboundSetPlayerTeamPacketBuilder();
    }

    @Generated
    public ClientboundSetPlayerTeamPacketBuilder toBuilder() {
        return new ClientboundSetPlayerTeamPacketBuilder().teamKey(this.teamKey).mode(this.mode).displayName(this.displayName).friendlyFire(this.friendlyFire).seeInvisible(this.seeInvisible).tagVisibility(this.tagVisibility).collisionRule(this.collisionRule).teamColor(this.teamColor).teamPrefix(this.teamPrefix).teamSuffix(this.teamSuffix).entities(this.entities);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetPlayerTeamPacket)) {
            return false;
        }
        ClientboundSetPlayerTeamPacket other = (ClientboundSetPlayerTeamPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.friendlyFire() != other.friendlyFire()) {
            return false;
        }
        if (this.seeInvisible() != other.seeInvisible()) {
            return false;
        }
        String this$teamKey = this.teamKey();
        String other$teamKey = other.teamKey();
        if (this$teamKey == null ? other$teamKey != null : !this$teamKey.equals(other$teamKey)) {
            return false;
        }
        Mode this$mode = this.mode();
        Mode other$mode = other.mode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        Component this$displayName = this.displayName();
        Component other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        TagVisibility this$tagVisibility = this.tagVisibility();
        TagVisibility other$tagVisibility = other.tagVisibility();
        if (this$tagVisibility == null ? other$tagVisibility != null : !((Object)((Object)this$tagVisibility)).equals((Object)other$tagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.collisionRule();
        CollisionRule other$collisionRule = other.collisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        TeamColor this$teamColor = this.teamColor();
        TeamColor other$teamColor = other.teamColor();
        if (this$teamColor == null ? other$teamColor != null : !((Object)((Object)this$teamColor)).equals((Object)other$teamColor)) {
            return false;
        }
        Component this$teamPrefix = this.teamPrefix();
        Component other$teamPrefix = other.teamPrefix();
        if (this$teamPrefix == null ? other$teamPrefix != null : !this$teamPrefix.equals(other$teamPrefix)) {
            return false;
        }
        Component this$teamSuffix = this.teamSuffix();
        Component other$teamSuffix = other.teamSuffix();
        if (this$teamSuffix == null ? other$teamSuffix != null : !this$teamSuffix.equals(other$teamSuffix)) {
            return false;
        }
        Collection<String> this$entities = this.entities();
        Collection<String> other$entities = other.entities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetPlayerTeamPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.friendlyFire() ? 79 : 97);
        result = result * 59 + (this.seeInvisible() ? 79 : 97);
        String $teamKey = this.teamKey();
        result = result * 59 + ($teamKey == null ? 43 : $teamKey.hashCode());
        Mode $mode = this.mode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        Component $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        TagVisibility $tagVisibility = this.tagVisibility();
        result = result * 59 + ($tagVisibility == null ? 43 : ((Object)((Object)$tagVisibility)).hashCode());
        CollisionRule $collisionRule = this.collisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        TeamColor $teamColor = this.teamColor();
        result = result * 59 + ($teamColor == null ? 43 : ((Object)((Object)$teamColor)).hashCode());
        Component $teamPrefix = this.teamPrefix();
        result = result * 59 + ($teamPrefix == null ? 43 : $teamPrefix.hashCode());
        Component $teamSuffix = this.teamSuffix();
        result = result * 59 + ($teamSuffix == null ? 43 : $teamSuffix.hashCode());
        Collection<String> $entities = this.entities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String teamKey() {
        return this.teamKey;
    }

    @NotNull
    @Generated
    public Mode mode() {
        return this.mode;
    }

    @Nullable
    @Generated
    public Component displayName() {
        return this.displayName;
    }

    @Generated
    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @Generated
    public boolean seeInvisible() {
        return this.seeInvisible;
    }

    @Nullable
    @Generated
    public TagVisibility tagVisibility() {
        return this.tagVisibility;
    }

    @Nullable
    @Generated
    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @Nullable
    @Generated
    public TeamColor teamColor() {
        return this.teamColor;
    }

    @Nullable
    @Generated
    public Component teamPrefix() {
        return this.teamPrefix;
    }

    @Nullable
    @Generated
    public Component teamSuffix() {
        return this.teamSuffix;
    }

    @Nullable
    @Generated
    public @Nullable Collection<@NotNull String> entities() {
        return this.entities;
    }

    @Generated
    public ClientboundSetPlayerTeamPacket teamPrefix(@Nullable Component teamPrefix) {
        this.teamPrefix = teamPrefix;
        return this;
    }

    @Generated
    public ClientboundSetPlayerTeamPacket teamSuffix(@Nullable Component teamSuffix) {
        this.teamSuffix = teamSuffix;
        return this;
    }

    @Generated
    public ClientboundSetPlayerTeamPacket entities(@Nullable Collection<@NotNull String> entities) {
        this.entities = entities;
        return this;
    }

    @Generated
    public String toString() {
        return "ClientboundSetPlayerTeamPacket(teamKey=" + this.teamKey() + ", mode=" + String.valueOf((Object)this.mode()) + ", displayName=" + String.valueOf(this.displayName()) + ", friendlyFire=" + this.friendlyFire() + ", seeInvisible=" + this.seeInvisible() + ", tagVisibility=" + String.valueOf((Object)this.tagVisibility()) + ", collisionRule=" + String.valueOf((Object)this.collisionRule()) + ", teamColor=" + String.valueOf((Object)this.teamColor()) + ", teamPrefix=" + String.valueOf(this.teamPrefix()) + ", teamSuffix=" + String.valueOf(this.teamSuffix()) + ", entities=" + String.valueOf(this.entities()) + ")";
    }

    public static enum Mode {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_ENTITY,
        REMOVE_ENTITY;

    }

    public static enum TagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        @NotNull
        private final String enumName;

        @Generated
        private TagVisibility(String enumName) {
            if (enumName == null) {
                throw new NullPointerException("enumName is marked non-null but is null");
            }
            this.enumName = enumName;
        }

        @NotNull
        @Generated
        public String enumName() {
            return this.enumName;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        @NotNull
        private final String enumName;

        @Generated
        private CollisionRule(String enumName) {
            if (enumName == null) {
                throw new NullPointerException("enumName is marked non-null but is null");
            }
            this.enumName = enumName;
        }

        @NotNull
        @Generated
        public String enumName() {
            return this.enumName;
        }
    }

    public static enum TeamColor {
        BLACK,
        DARK_BLUE,
        DARK_GREEN,
        DARK_AQUA,
        DARK_RED,
        DARK_PURPLE,
        GOLD,
        GRAY,
        DARK_GRAY,
        BLUE,
        GREEN,
        AQUA,
        RED,
        LIGHT_PURPLE,
        YELLOW,
        WHITE;

    }

    @Generated
    public static class ClientboundSetPlayerTeamPacketBuilder {
        @Generated
        private String teamKey;
        @Generated
        private Mode mode;
        @Generated
        private Component displayName;
        @Generated
        private boolean friendlyFire;
        @Generated
        private boolean seeInvisible;
        @Generated
        private TagVisibility tagVisibility;
        @Generated
        private CollisionRule collisionRule;
        @Generated
        private boolean teamColor$set;
        @Generated
        private TeamColor teamColor$value;
        @Generated
        private Component teamPrefix;
        @Generated
        private Component teamSuffix;
        @Generated
        private Collection<@NotNull String> entities;

        @Generated
        ClientboundSetPlayerTeamPacketBuilder() {
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder teamKey(@NotNull String teamKey) {
            if (teamKey == null) {
                throw new NullPointerException("teamKey is marked non-null but is null");
            }
            this.teamKey = teamKey;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder mode(@NotNull Mode mode) {
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.mode = mode;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder displayName(@Nullable Component displayName) {
            this.displayName = displayName;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder friendlyFire(boolean friendlyFire) {
            this.friendlyFire = friendlyFire;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder seeInvisible(boolean seeInvisible) {
            this.seeInvisible = seeInvisible;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder tagVisibility(@Nullable TagVisibility tagVisibility) {
            this.tagVisibility = tagVisibility;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder collisionRule(@Nullable CollisionRule collisionRule) {
            this.collisionRule = collisionRule;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder teamColor(@Nullable TeamColor teamColor) {
            this.teamColor$value = teamColor;
            this.teamColor$set = true;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder teamPrefix(@Nullable Component teamPrefix) {
            this.teamPrefix = teamPrefix;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder teamSuffix(@Nullable Component teamSuffix) {
            this.teamSuffix = teamSuffix;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacketBuilder entities(@Nullable Collection<@NotNull String> entities) {
            this.entities = entities;
            return this;
        }

        @Generated
        public ClientboundSetPlayerTeamPacket build() {
            TeamColor teamColor$value = this.teamColor$value;
            if (!this.teamColor$set) {
                teamColor$value = ClientboundSetPlayerTeamPacket.$default$teamColor();
            }
            return new ClientboundSetPlayerTeamPacket(this.teamKey, this.mode, this.displayName, this.friendlyFire, this.seeInvisible, this.tagVisibility, this.collisionRule, teamColor$value, this.teamPrefix, this.teamSuffix, this.entities);
        }

        @Generated
        public String toString() {
            return "ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder(teamKey=" + this.teamKey + ", mode=" + String.valueOf((Object)this.mode) + ", displayName=" + String.valueOf(this.displayName) + ", friendlyFire=" + this.friendlyFire + ", seeInvisible=" + this.seeInvisible + ", tagVisibility=" + String.valueOf((Object)this.tagVisibility) + ", collisionRule=" + String.valueOf((Object)this.collisionRule) + ", teamColor$value=" + String.valueOf((Object)this.teamColor$value) + ", teamPrefix=" + String.valueOf(this.teamPrefix) + ", teamSuffix=" + String.valueOf(this.teamSuffix) + ", entities=" + String.valueOf(this.entities) + ")";
        }
    }
}

