/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.Server;
import sba.sl.ev.EventExecutionOrder;
import sba.sl.ev.EventManager;
import sba.sl.ev.player.PlayerJoinEvent;
import sba.sl.ev.player.PlayerLeaveEvent;
import sba.sl.p.event.SPacketEvent;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.u.PacketMethod;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.annotations.methods.OnPreDisable;

@Service
@ServiceDependencies(dependsOn={EventManager.class, Players.class})
public class ProtocolInjector {
    @NotNull
    private static final String CHANNEL_NAME = "SPacketHandler";

    @OnPostEnable
    public void onPostEnable() {
        if (EventManager.getDefaultEventManager() == null) {
            throw new UnsupportedOperationException("Default EventManager is not initialized yet");
        }
        EventManager.getDefaultEventManager().register(PlayerJoinEvent.class, sPlayerJoinEvent -> this.addPlayer(sPlayerJoinEvent.player(), false), EventExecutionOrder.FIRST);
        EventManager.getDefaultEventManager().register(PlayerLeaveEvent.class, sPlayerLeaveEvent -> this.removePlayer(sPlayerLeaveEvent.player()), EventExecutionOrder.MONITOR);
        Server.getConnectedPlayers().forEach(player -> this.addPlayer((Player)player, false));
    }

    @OnPreDisable
    public void onPreDisable() {
        Server.getConnectedPlayers().forEach(this::removePlayer);
    }

    public void addPlayer(@NotNull Player player, boolean onLogin) {
        try {
            Channel channel = Players.getNettyChannel(player);
            Preconditions.checkNotNull(channel, "Failed to find player channel!");
            PacketHandler handler = new PacketHandler(player);
            if (channel.pipeline().get(CHANNEL_NAME) == null && channel.pipeline().get("packet_handler") != null) {
                channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", CHANNEL_NAME, (ChannelHandler)handler));
            }
        }
        catch (Throwable t) {
            if (onLogin) {
                return;
            }
            t.printStackTrace();
            player.kick(Component.text("Failed to inject!, please rejoin.."));
        }
    }

    public void removePlayer(@NotNull Player player) {
        try {
            Channel channel = Players.getNettyChannel(player);
            if (channel != null && channel.pipeline().get(CHANNEL_NAME) != null) {
                channel.eventLoop().submit(() -> channel.pipeline().remove(CHANNEL_NAME));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PacketHandler
    extends ChannelDuplexHandler {
        @NotNull
        private final Player player;

        public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
            SPacketEvent readEvent = EventManager.fire(new SPacketEvent(this.player, PacketMethod.INBOUND, packet));
            if (readEvent.isCancelled()) {
                return;
            }
            Object modifiedPacket = readEvent.getPacket();
            super.channelRead(ctx, modifiedPacket);
        }

        public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) throws Exception {
            SPacketEvent writeEvent = EventManager.fire(new SPacketEvent(this.player, PacketMethod.OUTBOUND, packet));
            if (writeEvent.cancelled()) {
                return;
            }
            Object modifiedPacket = writeEvent.getPacket();
            super.write(ctx, modifiedPacket, promise);
        }

        @Generated
        public PacketHandler(@NotNull Player player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
        }
    }
}

