/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.pa;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.particle.ParticleTypeRegistry;
import sba.sl.pa.ParticleData;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface ParticleType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Nullable
    public Class<? extends ParticleData> expectedDataClass();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.PARTICLE_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static ParticleType of(@MinecraftType(value=MinecraftType.Type.PARTICLE_TYPE) @NotNull Object particle) {
        ParticleType result = ParticleType.ofNullable(particle);
        Preconditions.checkNotNullIllegal(result, "Could not find particle type: " + String.valueOf(particle));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ParticleType ofNullable(@MinecraftType(value=MinecraftType.Type.PARTICLE_TYPE) @Nullable Object particle) {
        if (particle instanceof ParticleType) {
            return (ParticleType)particle;
        }
        return (ParticleType)ParticleTypeRegistry.getInstance().resolveMapping(particle);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull ParticleType> all() {
        return ParticleTypeRegistry.getInstance().getRegistryItemStream();
    }
}

