/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.pu;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceManager {
    @NotNull
    private static final @NotNull List<@NotNull Object> services = new LinkedList<Object>();

    @ApiStatus.Internal
    public static void putService(@NotNull Object service) {
        if (!services.contains(service)) {
            services.add(service);
        }
    }

    @NotNull
    public static <T> T get(@NotNull Class<T> serviceType) {
        return (T)services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).findFirst().orElseThrow();
    }

    public static <T> Optional<T> getOptional(@NotNull Class<T> serviceType) {
        return services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).findFirst();
    }

    @Nullable
    public static <T> T getNullable(@NotNull Class<T> serviceType) {
        return services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).findFirst().orElse(null);
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> getAll(@NotNull Class<T> serviceType) {
        return services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).collect(Collectors.toList());
    }

    @Generated
    private ServiceManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

