/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.si.team;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.pa.Player;
import sba.sl.s.CommandSender;
import sba.sl.si.TeamedSidebar;
import sba.sl.si.team.ScoreboardTeam;
import sba.sl.spectator.Component;
import sba.sl.spectator.audience.PlayerAudience;

public class ScoreboardTeamImpl
implements ScoreboardTeam {
    protected final TeamedSidebar<?> scoreboard;
    protected final String identifier;
    protected ClientboundSetPlayerTeamPacket.TeamColor color = ClientboundSetPlayerTeamPacket.TeamColor.WHITE;
    protected Component displayName = Component.empty();
    protected Component teamPrefix = Component.empty();
    protected Component teamSuffix = Component.empty();
    protected boolean friendlyFire = true;
    protected boolean seeInvisible = true;
    protected ClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility = ClientboundSetPlayerTeamPacket.TagVisibility.ALWAYS;
    protected ClientboundSetPlayerTeamPacket.CollisionRule collisionRule = ClientboundSetPlayerTeamPacket.CollisionRule.ALWAYS;
    protected final List<Player> players = new LinkedList<Player>();
    private final String teamKey;

    public ScoreboardTeamImpl(TeamedSidebar<?> scoreboard, String identifier) {
        this.scoreboard = scoreboard;
        this.identifier = identifier;
        this.teamKey = new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public ScoreboardTeam color(ClientboundSetPlayerTeamPacket.TeamColor color) {
        this.color = color;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam displayName(Component displayName) {
        this.displayName = displayName;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam teamPrefix(Component teamPrefix) {
        this.teamPrefix = teamPrefix;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam teamSuffix(Component teamSuffix) {
        this.teamSuffix = teamSuffix;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam friendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam seeInvisible(boolean seeInvisible) {
        this.seeInvisible = seeInvisible;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam nameTagVisibility(ClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility) {
        this.nameTagVisibility = nameTagVisibility;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam collisionRule(ClientboundSetPlayerTeamPacket.CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        this.updateInfo();
        return this;
    }

    @Override
    public ScoreboardTeam player(Player player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.sendAddPlayer(player);
        }
        return this;
    }

    @Override
    public ScoreboardTeam removePlayer(Player player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.sendRemovePlayer(player);
        }
        return this;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Player> players() {
        return List.copyOf(this.players);
    }

    @Override
    @NotNull
    public @NotNull Iterable<? extends @NotNull PlayerAudience> audiences() {
        return this.players();
    }

    public ClientboundSetPlayerTeamPacket constructDestructPacket() {
        return this.getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode.REMOVE).build();
    }

    private ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode mode) {
        return ClientboundSetPlayerTeamPacket.builder().teamKey(this.teamKey).mode(mode);
    }

    public ClientboundSetPlayerTeamPacket constructCreatePacket() {
        ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet = this.getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode.CREATE);
        this.packInfo(packet);
        this.packPlayers(packet, this.players);
        return packet.build();
    }

    private void packInfo(ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet) {
        packet.displayName(this.displayName).friendlyFire(this.friendlyFire).seeInvisible(this.seeInvisible).tagVisibility(this.nameTagVisibility).collisionRule(this.collisionRule).teamColor(this.color).teamPrefix(this.teamPrefix).teamSuffix(this.teamSuffix);
    }

    private void packPlayers(ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet, List<Player> players) {
        packet.entities(players.stream().map(CommandSender::getName).collect(Collectors.toList()));
    }

    protected void updateInfo() {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet = this.getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode.UPDATE);
            this.packInfo(packet);
            packet.build().sendPacket(this.scoreboard.viewers());
        }
    }

    protected void sendAddPlayer(Player player) {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet = this.getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode.ADD_ENTITY);
            this.packPlayers(packet, List.of(player));
            packet.build().sendPacket(this.scoreboard.viewers());
        }
    }

    protected void sendRemovePlayer(Player player) {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            ClientboundSetPlayerTeamPacket.ClientboundSetPlayerTeamPacketBuilder packet = this.getNotFinalScoreboardTeamPacket(ClientboundSetPlayerTeamPacket.Mode.REMOVE_ENTITY);
            this.packPlayers(packet, List.of(player));
            packet.build().sendPacket(this.scoreboard.viewers());
        }
    }

    @Override
    public void destroy() {
        if (this.scoreboard.shown() && this.scoreboard.hasViewers()) {
            ClientboundSetPlayerTeamPacket packet = this.constructDestructPacket();
            packet.sendPacket(this.scoreboard.viewers());
        }
    }

    @Generated
    public TeamedSidebar<?> scoreboard() {
        return this.scoreboard;
    }

    @Override
    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public ClientboundSetPlayerTeamPacket.TeamColor color() {
        return this.color;
    }

    @Override
    @Generated
    public Component displayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public Component teamPrefix() {
        return this.teamPrefix;
    }

    @Override
    @Generated
    public Component teamSuffix() {
        return this.teamSuffix;
    }

    @Override
    @Generated
    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @Override
    @Generated
    public boolean seeInvisible() {
        return this.seeInvisible;
    }

    @Override
    @Generated
    public ClientboundSetPlayerTeamPacket.TagVisibility nameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    @Generated
    public ClientboundSetPlayerTeamPacket.CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @Generated
    public String teamKey() {
        return this.teamKey;
    }
}

