/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.bossbar;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Component;
import sba.sl.spectator.bossbar.BossBarColor;
import sba.sl.spectator.bossbar.BossBarDivision;
import sba.sl.spectator.bossbar.BossBarFlag;
import sba.sl.spectator.bossbar.BossBarListener;
import sba.sl.spectator.bossbar.RegisteredListener;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public interface BossBar
extends Wrapper,
RawValueHolder {
    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().bossBar();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static BossBar bossBar() {
        return BossBar.builder().build();
    }

    @NotNull
    public Component title();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar title(@NotNull Component var1);

    public float progress();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar progress(float var1);

    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BossBarFlag> flags();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar flags(@NotNull @NotNull List<@NotNull BossBarFlag> var1);

    @NotNull
    public BossBarColor color();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar color(@NotNull BossBarColor var1);

    @NotNull
    public BossBarDivision division();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar division(@NotNull BossBarDivision var1);

    @Contract(value="_ -> new")
    @NotNull
    public RegisteredListener addListener(@NotNull BossBarListener var1);

    public void removeListener(@NotNull RegisteredListener var1);

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder title(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder progress(float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder color(@NotNull BossBarColor var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder division(@NotNull BossBarDivision var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder flags(@NotNull @NotNull Collection<@NotNull BossBarFlag> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder flags(BossBarFlag ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder listener(@NotNull BossBarListener var1);

        @LimitedVersionSupport(value="1.8.8; has no effect on any other version")
        @Contract(value="_ -> this")
        @NotNull
        default public Builder enableViaHooks(boolean enableViaHooks) {
            return this;
        }

        @LimitedVersionSupport(value="1.8.8; has no effect on any other version")
        @Contract(value="_ -> this")
        @NotNull
        default public Builder preferEnderDragonBossBar(boolean preferEnderDragonBossBar) {
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public BossBar build();
    }
}

