/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.event;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.nbt.Tag;
import sba.sl.spectator.dialog.Dialog;
import sba.sl.spectator.event.click.Payload;
import sba.sl.u.RawValueHolder;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public interface ClickEvent
extends Wrapper,
RawValueHolder {
    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().clickEvent();
    }

    @LimitedVersionSupport(value=">= 1.15")
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent copyToClipboard(@NotNull String value) {
        return Spectator.getBackend().clickEvent().action(Action.COPY_TO_CLIPBOARD).payload(Payload.text(value)).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent openUrl(@NotNull String value) {
        return Spectator.getBackend().clickEvent().action(Action.OPEN_URL).payload(Payload.text(value)).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent openFile(@NotNull String value) {
        return Spectator.getBackend().clickEvent().action(Action.OPEN_FILE).payload(Payload.text(value)).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent runCommand(@NotNull String value) {
        return Spectator.getBackend().clickEvent().action(Action.RUN_COMMAND).payload(Payload.text(value)).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent suggestCommand(@NotNull String value) {
        return Spectator.getBackend().clickEvent().action(Action.SUGGEST_COMMAND).payload(Payload.text(value)).build();
    }

    @Deprecated(forRemoval=true)
    @LimitedVersionSupport(value=">= 1.15")
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ClickEvent changePage(@NotNull String value) {
        try {
            return ClickEvent.changePage(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Cannot set value " + value + " as payload for CHANGE_PAGE click event", e);
        }
    }

    @Contract(value="_ -> new", pure=true)
    @LimitedVersionSupport(value=">= 1.15")
    @NotNull
    public static ClickEvent changePage(int page) {
        return Spectator.getBackend().clickEvent().action(Action.CHANGE_PAGE).payload(Payload.integer(page)).build();
    }

    @Contract(value="_, _ -> new", pure=true)
    @LimitedVersionSupport(value=">= 1.21.6")
    @NotNull
    public static ClickEvent custom(@NotNull ResourceLocation id, @Nullable Tag data) {
        return Spectator.getBackend().clickEvent().action(Action.CUSTOM).payload(Payload.custom(id, data)).build();
    }

    @Contract(value="_ -> new", pure=true)
    @LimitedVersionSupport(value=">= 1.21.6")
    @NotNull
    public static ClickEvent showDialog(@NotNull Dialog dialog) {
        return Spectator.getBackend().clickEvent().action(Action.SHOW_DIALOG).payload(Payload.showDialog(dialog)).build();
    }

    @NotNull
    public Action action();

    @Contract(pure=true)
    @NotNull
    public ClickEvent withAction(@NotNull Action var1);

    @Deprecated(forRemoval=true)
    @NotNull
    default public String value() {
        Payload payload = this.payload();
        if (payload instanceof Payload.Text) {
            return ((Payload.Text)payload).text();
        }
        if (payload instanceof Payload.Int) {
            return String.valueOf(((Payload.Int)payload).number());
        }
        throw new IllegalStateException("Payload is not a string payload, is " + String.valueOf(payload));
    }

    @Deprecated(forRemoval=true)
    @Contract(pure=true)
    @NotNull
    default public ClickEvent withValue(@NotNull String value) {
        return this.withPayload(Payload.text(value));
    }

    @NotNull
    public Payload payload();

    @Contract(pure=true)
    @NotNull
    public ClickEvent withPayload(@NotNull Payload var1);

    @Contract(value="-> new", pure=true)
    public @NotNull Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder action(@NotNull Action var1);

        @Deprecated(forRemoval=true)
        @Contract(value="_ -> this")
        @NotNull
        default public Builder value(@NotNull String value) {
            return this.payload(Payload.text(value));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder payload(@NotNull Payload var1);

        @Contract(value="-> new", pure=true)
        @NotNull
        public ClickEvent build();
    }

    public static enum Action {
        OPEN_URL,
        OPEN_FILE,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        CHANGE_PAGE,
        COPY_TO_CLIPBOARD,
        SHOW_DIALOG,
        CUSTOM;


        @NotNull
        public Class<? extends Payload> supportedPayload() {
            switch (this.ordinal()) {
                case 4: {
                    return Payload.Int.class;
                }
                case 6: {
                    return Payload.ShowDialog.class;
                }
                case 7: {
                    return Payload.Custom.class;
                }
            }
            return Payload.Text.class;
        }

        public boolean supportsPayload(@NotNull Class<? extends Payload> payloadClass) {
            return this.supportedPayload().isAssignableFrom(payloadClass) || this == CHANGE_PAGE && Payload.Text.class.isAssignableFrom(payloadClass);
        }
    }
}

