/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.text.ChoiceFormat;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.Component;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.placeholders.StringLikePlaceholder;

public abstract class ChoicePlaceholder
implements Placeholder,
StringLikePlaceholder {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    private final String name;

    @NotNull
    public abstract Number getValue();

    @Override
    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B getResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        Number value = this.getValue();
        if (arguments.size() == 1) {
            try {
                return parser.parseIntoBuilder(new ChoiceFormat(arguments.get(0)).format(value), placeholders);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (B)Component.text().content(value);
    }

    @Override
    @NotNull
    public String getStringResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        Number value = this.getValue();
        if (arguments.size() == 1) {
            try {
                return parser.resolvePlaceholdersInString(new ChoiceFormat(arguments.get(0)).format(value), placeholders);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return String.valueOf(value);
    }

    @Generated
    public ChoicePlaceholder(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChoicePlaceholder)) {
            return false;
        }
        ChoicePlaceholder other = (ChoicePlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChoicePlaceholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChoicePlaceholder(name=" + this.getName() + ")";
    }

    public static final class Lazy
    extends ChoicePlaceholder {
        @NotNull
        private final @NotNull Supplier<@NotNull Number> supplier;

        public Lazy(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Number> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public Number getValue() {
            return this.supplier.get();
        }

        @NotNull
        @Generated
        public @NotNull Supplier<@NotNull Number> getSupplier() {
            return this.supplier;
        }
    }

    public static final class Constant
    extends ChoicePlaceholder {
        @NotNull
        private final Number value;

        public Constant(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull Number value) {
            super(name);
            this.value = value;
        }

        @Override
        @NotNull
        @Generated
        public Number getValue() {
            return this.value;
        }
    }
}

