/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Component;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.BooleanPlaceholder;
import sba.sl.spectator.mini.placeholders.CharPlaceholder;
import sba.sl.spectator.mini.placeholders.ChoicePlaceholder;
import sba.sl.spectator.mini.placeholders.ComponentPlaceholder;
import sba.sl.spectator.mini.placeholders.DateTimePlaceholder;
import sba.sl.spectator.mini.placeholders.MiniPlaceholder;
import sba.sl.spectator.mini.placeholders.NumberPlaceholder;
import sba.sl.spectator.mini.placeholders.StringPlaceholder;
import sba.sl.spectator.mini.resolvers.SingleTagResolver;

public interface Placeholder
extends SingleTagResolver {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    public String getName();

    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B getResult(@NotNull MiniMessageParser var1, @NotNull @NotNull List<@NotNull String> var2, Placeholder ... var3);

    @Override
    @NotNull
    default public <B extends Component.Builder<B, C>, C extends Component> B resolve(@NotNull MiniMessageParser parser, @NotNull TagNode tag, Placeholder ... placeholders) {
        return this.getResult(parser, tag.getArgs(), placeholders);
    }

    @NotNull
    public static Placeholder component(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull Component component) {
        return new ComponentPlaceholder.Constant(name, component);
    }

    @NotNull
    public static Placeholder lazyComponent(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Component> component) {
        return new ComponentPlaceholder.Lazy(name, component);
    }

    @NotNull
    public static Placeholder unparsed(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull String value) {
        return new StringPlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyUnparsed(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull String> value) {
        return new StringPlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder parsed(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull String value) {
        return new MiniPlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyParsed(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull String> value) {
        return new MiniPlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder number(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull Number value) {
        return new NumberPlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyNumber(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Number> value) {
        return new NumberPlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder lazyNumber(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull IntSupplier value) {
        return new NumberPlaceholder.Lazy(name, value::getAsInt);
    }

    @NotNull
    public static Placeholder lazyNumber(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull LongSupplier value) {
        return new NumberPlaceholder.Lazy(name, value::getAsLong);
    }

    @NotNull
    public static Placeholder lazyNumber(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull DoubleSupplier value) {
        return new NumberPlaceholder.Lazy(name, value::getAsDouble);
    }

    @NotNull
    public static Placeholder bool(@Pattern(value="[a-z\\d_-]+") @NotNull String name, boolean value) {
        return new BooleanPlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyBool(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull BooleanSupplier value) {
        return new BooleanPlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder character(@Pattern(value="[a-z\\d_-]+") @NotNull String name, char value) {
        return new CharPlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyCharacter(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Character> value) {
        return new CharPlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder dateTime(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull TemporalAccessor value) {
        return new DateTimePlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyDateTime(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull TemporalAccessor> value) {
        return new DateTimePlaceholder.Lazy(name, value);
    }

    @NotNull
    public static Placeholder choice(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull Number value) {
        return new ChoicePlaceholder.Constant(name, value);
    }

    @NotNull
    public static Placeholder lazyChoice(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull @NotNull Supplier<@NotNull Number> value) {
        return new ChoicePlaceholder.Lazy(name, value);
    }
}

