/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.sound;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.u.RawValueHolder;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.MinecraftType;

public interface SoundStop
extends Wrapper,
RawValueHolder {
    @Contract(value="-> new", pure=true)
    @NotNull
    public static SoundStop all() {
        return SoundStop.builder().build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SoundStop named(@Nullable ResourceLocation soundKey) {
        return SoundStop.builder().soundKey(soundKey).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SoundStop minecraftNamed(@MinecraftType(value=MinecraftType.Type.SOUND) @Nullable String soundKey) {
        return SoundStop.builder().soundKey(soundKey).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SoundStop sourced(@Nullable SoundSource source) {
        return SoundStop.builder().source(source).build();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static SoundStop namedSourced(@Nullable ResourceLocation soundKey, @Nullable SoundSource source) {
        return SoundStop.builder().soundKey(soundKey).source(source).build();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static SoundStop minecraftNamedSourced(@MinecraftType(value=MinecraftType.Type.SOUND) @Nullable String soundKey, @Nullable SoundSource source) {
        return SoundStop.builder().soundKey(soundKey).source(source).build();
    }

    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().soundStop();
    }

    @Nullable
    public ResourceLocation soundKey();

    @Nullable
    public SoundSource source();

    @Contract(pure=true)
    @NotNull
    public SoundStop withSoundKey(@Nullable ResourceLocation var1);

    @Contract(pure=true)
    @NotNull
    public SoundStop withSource(@Nullable SoundSource var1);

    @Contract(value="-> new", pure=true)
    public @NotNull Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder soundKey(@Nullable ResourceLocation var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder soundKey(@MinecraftType(value=MinecraftType.Type.SOUND) @Nullable String key) {
            return this.soundKey(key != null ? ResourceLocation.of(key) : null);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder source(@Nullable SoundSource var1);

        @Contract(value="-> new", pure=true)
        @NotNull
        public SoundStop build();
    }
}

