/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.title;

import java.time.Duration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Component;
import sba.sl.spectator.title.TimesProvider;
import sba.sl.u.RawValueHolder;

public interface Title
extends Wrapper,
RawValueHolder,
TimesProvider {
    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Title title(@NotNull Component title, @NotNull Component subtitle) {
        return Title.builder().title(title).subtitle(subtitle).build();
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static Title title(@NotNull Component title, @NotNull Component subtitle, @Nullable TimesProvider times) {
        return Title.builder().title(title).subtitle(subtitle).times(times).build();
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static Title title(@NotNull Component title, @NotNull Component subtitle, @Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
        return Title.builder().title(title).subtitle(subtitle).times(fadeIn, stay, fadeOut).build();
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static Title title(@NotNull Component title, @NotNull Component subtitle, long fadeIn, long stay, long fadeOut) {
        return Title.builder().title(title).subtitle(subtitle).times(fadeIn, stay, fadeOut).build();
    }

    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().title();
    }

    @NotNull
    public Component title();

    @Contract(pure=true)
    @NotNull
    public Title withTitle(@NotNull Component var1);

    @NotNull
    public Component subtitle();

    @Contract(pure=true)
    @NotNull
    public Title withSubtitle(@NotNull Component var1);

    @Contract(pure=true)
    @NotNull
    public Title withTimes(@NotNull TimesProvider var1);

    @Contract(pure=true)
    @NotNull
    public Title withTimes(@Nullable Duration var1, @Nullable Duration var2, @Nullable Duration var3);

    @Contract(pure=true)
    @NotNull
    public Title withTimes(long var1, long var3, long var5);

    @Contract(pure=true)
    @NotNull
    public Title withFadeIn(@Nullable Duration var1);

    @Contract(pure=true)
    @NotNull
    public Title withStay(@Nullable Duration var1);

    @Contract(pure=true)
    @NotNull
    public Title withFadeOut(@Nullable Duration var1);

    @Contract(pure=true)
    @NotNull
    public Title withFadeIn(long var1);

    @Contract(pure=true)
    @NotNull
    public Title withStay(long var1);

    @Contract(pure=true)
    @NotNull
    public Title withFadeOut(long var1);

    @Contract(value="-> new", pure=true)
    public @NotNull Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder title(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder subtitle(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder fadeIn(@Nullable Duration var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder fadeIn(long ticks) {
            return this.fadeIn(Duration.ofMillis(ticks * 50L));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder stay(@Nullable Duration var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder stay(long ticks) {
            return this.stay(Duration.ofMillis(ticks * 50L));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder fadeOut(@Nullable Duration var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder fadeOut(long ticks) {
            return this.fadeOut(Duration.ofMillis(ticks * 50L));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder times(@Nullable TimesProvider times) {
            if (times != null) {
                this.fadeIn(times.fadeIn());
                this.stay(times.stay());
                this.fadeOut(times.fadeOut());
            } else {
                this.fadeIn(null);
                this.stay(null);
                this.fadeOut(null);
            }
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder times(@Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
            this.fadeIn(fadeIn);
            this.stay(stay);
            this.fadeOut(fadeOut);
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder times(long fadeIn, long stay, long fadeOut) {
            this.fadeIn(fadeIn);
            this.stay(stay);
            this.fadeOut(fadeOut);
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public Title build();
    }
}

