/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Component;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.TranslatableComponent;

public class TextToComponentReplacement {
    @NotNull
    private final Pattern matchPattern;
    @NotNull
    private final @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement;

    @NotNull
    public Component replace(@NotNull Component component) {
        List<Component> arguments;
        List<Component> originalChildren = component.children();
        if ((component = component.withChildren(List.of())) instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            if (!content.isEmpty()) {
                String s;
                Matcher matcher = this.matchPattern.matcher(content);
                int lastIndex = 0;
                ArrayList<Object> results = new ArrayList<Object>();
                while (matcher.find()) {
                    Object e;
                    Component replacement;
                    s = content.substring(lastIndex, matcher.start());
                    if (!s.isEmpty()) {
                        Object e2;
                        if (!results.isEmpty() && (e2 = results.get(results.size() - 1)) instanceof String) {
                            results.set(results.size() - 1, String.valueOf(e2) + s);
                        } else {
                            results.add(s);
                        }
                    }
                    if ((replacement = this.replacement.apply(matcher)) != null) {
                        results.add(replacement);
                    } else if (!results.isEmpty() && (e = results.get(results.size() - 1)) instanceof String) {
                        results.set(results.size() - 1, String.valueOf(e) + matcher.group());
                    } else {
                        results.add(matcher.group());
                    }
                    lastIndex = matcher.end();
                }
                if (!(results.isEmpty() || results.size() == 1 && results.get(0) instanceof String)) {
                    if (lastIndex < content.length()) {
                        s = content.substring(lastIndex);
                        Object e = results.get(results.size() - 1);
                        if (e instanceof String) {
                            results.set(results.size() - 1, String.valueOf(e) + s);
                        } else {
                            results.add(s);
                        }
                    }
                    component = ((TextComponent)component).withContent("");
                    for (Object e : results) {
                        if (component.children().isEmpty() && ((TextComponent)component).content().isEmpty() && e instanceof String) {
                            component = ((TextComponent)component).withContent((String)e);
                            continue;
                        }
                        if (e instanceof Component) {
                            component = component.withAppendix((Component)e);
                            continue;
                        }
                        component = component.withAppendix(e.toString());
                    }
                }
            }
        } else if (component instanceof TranslatableComponent && !(arguments = ((TranslatableComponent)component).args()).isEmpty()) {
            ArrayList<Component> narguments = new ArrayList<Component>(arguments.size());
            for (Component arg : arguments) {
                narguments.add(this.replace(arg));
            }
            component = ((TranslatableComponent)component).withArgs(narguments);
        }
        if (!originalChildren.isEmpty()) {
            ArrayList<Component> newChildren = new ArrayList<Component>(originalChildren.size());
            for (Component child : originalChildren) {
                newChildren.add(this.replace(child));
            }
            component = component.withAppendix(newChildren);
        }
        return component;
    }

    @Generated
    TextToComponentReplacement(@NotNull Pattern matchPattern, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement) {
        if (matchPattern == null) {
            throw new NullPointerException("matchPattern is marked non-null but is null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement is marked non-null but is null");
        }
        this.matchPattern = matchPattern;
        this.replacement = replacement;
    }

    @Generated
    public static TextToComponentReplacementBuilder builder() {
        return new TextToComponentReplacementBuilder();
    }

    @NotNull
    @Generated
    public Pattern matchPattern() {
        return this.matchPattern;
    }

    @NotNull
    @Generated
    public @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement() {
        return this.replacement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextToComponentReplacement)) {
            return false;
        }
        TextToComponentReplacement other = (TextToComponentReplacement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pattern this$matchPattern = this.matchPattern();
        Pattern other$matchPattern = other.matchPattern();
        if (this$matchPattern == null ? other$matchPattern != null : !this$matchPattern.equals(other$matchPattern)) {
            return false;
        }
        Function<MatchResult, Component> this$replacement = this.replacement();
        Function<MatchResult, Component> other$replacement = other.replacement();
        return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextToComponentReplacement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $matchPattern = this.matchPattern();
        result = result * 59 + ($matchPattern == null ? 43 : $matchPattern.hashCode());
        Function<MatchResult, Component> $replacement = this.replacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TextToComponentReplacement(matchPattern=" + String.valueOf(this.matchPattern()) + ", replacement=" + String.valueOf(this.replacement()) + ")";
    }

    @Generated
    public static class TextToComponentReplacementBuilder {
        @Generated
        private Pattern matchPattern;
        @Generated
        private Function<@NotNull MatchResult, @Nullable Component> replacement;

        @Generated
        TextToComponentReplacementBuilder() {
        }

        @Generated
        public TextToComponentReplacementBuilder matchPattern(@NotNull Pattern matchPattern) {
            if (matchPattern == null) {
                throw new NullPointerException("matchPattern is marked non-null but is null");
            }
            this.matchPattern = matchPattern;
            return this;
        }

        @Generated
        public TextToComponentReplacementBuilder replacement(@NotNull @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement) {
            if (replacement == null) {
                throw new NullPointerException("replacement is marked non-null but is null");
            }
            this.replacement = replacement;
            return this;
        }

        @Generated
        public TextToComponentReplacement build() {
            return new TextToComponentReplacement(this.matchPattern, this.replacement);
        }

        @Generated
        public String toString() {
            return "TextToComponentReplacement.TextToComponentReplacementBuilder(matchPattern=" + String.valueOf(this.matchPattern) + ", replacement=" + String.valueOf(this.replacement) + ")";
        }
    }
}

