/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u;

import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.u.ComparableWrapper;

public class ResourceLocation
implements CharSequence,
ComparableWrapper {
    @NotNull
    private final String namespace;
    @NotNull
    private final String path;

    @Nullable
    public static ResourceLocation ofNullable(@Nullable String combinedString) {
        if (combinedString == null) {
            return null;
        }
        @Nullable String namespace = null;
        StringBuilder builder = new StringBuilder(combinedString.length());
        int length = combinedString.length();
        boolean whitespaceCharacter = false;
        boolean slashUsed = false;
        for (int i = 0; i < length; ++i) {
            char c = combinedString.charAt(i);
            if (c == ' ') {
                whitespaceCharacter = true;
                continue;
            }
            if (whitespaceCharacter) {
                whitespaceCharacter = false;
                if (c != '/' && c != ':' && builder.length() != 0) {
                    builder.append('_');
                }
            }
            if (c >= 'A' && c <= 'Z') {
                builder.append((char)(c + 32));
                continue;
            }
            if (c == '/') {
                slashUsed = true;
                builder.append('/');
                continue;
            }
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') {
                builder.append(c);
                continue;
            }
            if (c == ':' && namespace == null) {
                if (slashUsed) {
                    return null;
                }
                namespace = builder.toString();
                builder.setLength(0);
                continue;
            }
            return null;
        }
        if (builder.length() == 0) {
            return null;
        }
        return new ResourceLocation(namespace == null ? "minecraft" : namespace, builder.toString());
    }

    @NotNull
    public static ResourceLocation of(@NotNull String combinedString) {
        ResourceLocation result = ResourceLocation.ofNullable(combinedString);
        if (result == null) {
            throw new IllegalArgumentException(combinedString + " doesn't match validation patterns!");
        }
        return result;
    }

    @Nullable
    public static ResourceLocation ofNullable(@NotNull String namespace, @NotNull String path) {
        char c;
        int i;
        int length = namespace.length();
        for (i = 0; i < length; ++i) {
            c = namespace.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') continue;
            return null;
        }
        length = path.length();
        for (i = 0; i < length; ++i) {
            c = path.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == '/') continue;
            return null;
        }
        return new ResourceLocation(namespace, path);
    }

    @NotNull
    public static ResourceLocation of(@NotNull String namespace, @NotNull String path) {
        ResourceLocation result = ResourceLocation.ofNullable(namespace, path);
        if (result == null) {
            throw new IllegalArgumentException(namespace + ":" + path + " doesn't match validation patterns!");
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.path);
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ResourceLocation) {
            return this.namespace.equals(((ResourceLocation)object).namespace) && this.path.equals(((ResourceLocation)object).path);
        }
        ResourceLocation namespacedKey = ResourceLocation.of(object.toString());
        return this.namespace.equals(namespacedKey.namespace) && this.path.equals(namespacedKey.path);
    }

    @Override
    @NotNull
    public String toString() {
        return this.namespace + ":" + this.path;
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        if (type.isAssignableFrom(String.class)) {
            return (T)type.toString();
        }
        throw new UnsupportedOperationException("Can't convert wrapper to " + type.getName());
    }

    @NotNull
    public String asString() {
        return this.toString();
    }

    @Override
    public boolean is(@Nullable Object object) {
        return this.equals(object);
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public int length() {
        return this.asString().length();
    }

    @Override
    public char charAt(int index) {
        return this.asString().charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.asString().subSequence(start, end);
    }

    @NotNull
    @Generated
    public String namespace() {
        return this.namespace;
    }

    @NotNull
    @Generated
    public String path() {
        return this.path;
    }

    @Generated
    protected ResourceLocation(@NotNull String namespace, @NotNull String path) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.namespace = namespace;
        this.path = path;
    }
}

