/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.config;

import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.loader.AbstractConfigurationLoader;
import sba.sl.u.config.HoconConfigurationLoaderBuilderSupplier;
import sba.sl.u.config.JsonConfigurationLoaderBuilderSupplier;
import sba.sl.u.config.XmlConfigurationLoaderBuilderSupplier;
import sba.sl.u.config.YamlConfigurationLoaderBuilderSupplier;

@FunctionalInterface
public interface ConfigurationLoaderBuilderSupplier
extends Supplier<AbstractConfigurationLoader.Builder<?, ?>> {
    @Override
    public  @NotNull AbstractConfigurationLoader.Builder<?, ?> get() throws UnsupportedOperationException;

    default public  @NotNull AbstractConfigurationLoader.Builder<?, ?> getForLoadingOnly() throws UnsupportedOperationException {
        return this.get();
    }

    @Nullable
    public static ConfigurationLoaderBuilderSupplier getForExtension(@NotNull String extension) {
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "yml": 
            case "yaml": {
                return YamlConfigurationLoaderBuilderSupplier.INSTANCE;
            }
            case "json": {
                return JsonConfigurationLoaderBuilderSupplier.INSTANCE;
            }
            case "xml": {
                return XmlConfigurationLoaderBuilderSupplier.INSTANCE;
            }
            case "conf": 
            case "hocon": {
                return HoconConfigurationLoaderBuilderSupplier.INSTANCE;
            }
        }
        return null;
    }
}

