/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi.impl;

import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.vi.LocatableVisual;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractVisual;
import sba.sl.w.Location;

public abstract class AbstractLocatableVisual<T extends LocatableVisual<T>>
extends AbstractVisual<T>
implements LocatableVisual<T> {
    private volatile int viewDistance;
    @NotNull
    private volatile Location location;
    private volatile boolean created;

    public AbstractLocatableVisual(@NotNull UUID uuid, @NotNull Location location) {
        super(uuid);
        Objects.requireNonNull(location, "Location cannot be null!");
        this.viewDistance = 4096;
        this.location = location;
    }

    @Override
    public boolean created() {
        return this.created;
    }

    @Override
    public int viewDistance() {
        return this.viewDistance;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T viewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        return (T)this;
    }

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    @Override
    @NotNull
    public T location(@NotNull Location location) {
        Objects.requireNonNull(location, "Location cannot be null!");
        this.location = location;
        this.update(UpdateStrategy.POSITION);
        return (T)this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public T spawn() {
        if (this.created) {
            throw new UnsupportedOperationException("Visual: " + String.valueOf(this.uuid) + " is already spawned!");
        }
        this.show();
        this.created = true;
        return (T)this;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            throw new UnsupportedOperationException("Visual: " + String.valueOf(this.uuid) + " is already destroyed!");
        }
        this.hide();
        this.destroyed = true;
    }
}

