/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi.impl;

import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.vi.TouchableVisual;
import sba.sl.vi.impl.AbstractLocatableVisual;
import sba.sl.w.Location;

public abstract class AbstractTouchableVisual<T extends TouchableVisual<T>>
extends AbstractLocatableVisual<T>
implements TouchableVisual<T> {
    private volatile boolean touchable;
    private volatile long clickCoolDown;

    public AbstractTouchableVisual(@NotNull UUID uuid, @NotNull Location location, boolean touchable) {
        super(uuid, location);
        this.touchable = touchable;
        this.clickCoolDown = 20L;
    }

    @Override
    public boolean touchable() {
        return this.touchable;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T touchable(boolean touchable) {
        this.touchable = touchable;
        return (T)this;
    }

    @Override
    public long clickCooldown() {
        return this.clickCoolDown;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T clickCooldown(long delay) {
        if (delay < 0L) {
            return (T)this;
        }
        this.clickCoolDown = delay;
        return (T)this;
    }
}

