/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.api.types.server.LocationHolder;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entity;
import sba.sl.impl.world.Locations;
import sba.sl.pa.Particle;
import sba.sl.pa.Vibration;
import sba.sl.t.ThreadProperty;
import sba.sl.u.BlockFace;
import sba.sl.u.math.Vector3D;
import sba.sl.u.math.Vector3Df;
import sba.sl.u.math.Vector3Di;
import sba.sl.w.World;
import sba.sl.w.chunk.Chunk;

public class Location
implements Wrapper,
ThreadProperty,
Vibration.Destination,
LocationHolder {
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    @NotNull
    private final World world;

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public Location add(double x, double y, double z) {
        return this.toBuilder().x(this.x + x).y(this.y + y).z(this.z + z).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull Location holder) {
        return this.add(holder.getX(), holder.getY(), holder.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull Vector3D vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull Vector3Df vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull Vector3Di vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull BlockFace blockFace) {
        return this.add(blockFace.getBlockDirection());
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public Location add(@NotNull BlockFace blockFace, int distance) {
        return this.add(blockFace.getBlockDirection().multiply(distance));
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public Location subtract(double x, double y, double z) {
        return this.toBuilder().x(this.x - x).y(this.y - y).z(this.z - z).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull Location holder) {
        return this.subtract(holder.getX(), holder.getY(), holder.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull Vector3D vec) {
        return this.subtract(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull Vector3Df vec) {
        return this.subtract(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull Vector3Di vec) {
        return this.subtract(vec.getX(), vec.getY(), vec.getZ());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull BlockFace blockFace) {
        return this.subtract(blockFace.getBlockDirection());
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public Location subtract(@NotNull BlockFace blockFace, int distance) {
        return this.subtract(blockFace.getBlockDirection().multiply(distance));
    }

    @Contract(value="null -> null")
    @Nullable
    public static Location fromPlatform(@Nullable Object obj) {
        return Locations.resolve(obj);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        return Locations.convert(this, type);
    }

    public double getDistanceSquared(@NotNull Location holder) {
        double dx = this.getX() - holder.getX();
        double dy = this.getY() - holder.getY();
        double dz = this.getZ() - holder.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    @NotNull
    public Vector3D asVector() {
        return new Vector3D(this.x, this.y, this.z);
    }

    @NotNull
    public Vector3Df asVectorf() {
        return new Vector3Df((float)this.x, (float)this.y, (float)this.z);
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    @NotNull
    public Vector3D getFacingDirection() {
        Vector3D vector = new Vector3D();
        vector.setY(-Math.sin(Math.toRadians(this.pitch)));
        double xz = Math.cos(Math.toRadians(this.pitch));
        vector.setX(-xz * Math.sin(Math.toRadians(this.yaw)));
        vector.setZ(xz * Math.cos(Math.toRadians(this.yaw)));
        return vector;
    }

    @NotNull
    public BlockPlacement getBlock() {
        return this.as(BlockPlacement.class);
    }

    @NotNull
    public Chunk getChunk() {
        return Objects.requireNonNull(this.getWorld().getChunkAt(this));
    }

    public void sendParticle(@NotNull Particle particle) {
        this.getWorld().sendParticle(particle, this);
    }

    @NotNull
    public BlockPlacement getHighestBlock() {
        return this.getWorld().getHighestBlockAt(this.getBlockX(), this.getBlockZ());
    }

    public int getHighestY() {
        return this.getWorld().getHighestYAt(this.getBlockX(), this.getBlockZ());
    }

    @NotNull
    public Location clone() {
        return new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.world);
    }

    @NotNull
    public @NotNull List<@NotNull Entity> getNearbyEntities(int radius) {
        return this.world.getEntities().stream().filter(e -> this.isInRange(e.getLocation(), radius)).collect(Collectors.toList());
    }

    @NotNull
    public <T extends Entity> @NotNull List<@NotNull T> getNearbyEntitiesByClass(@NotNull Class<T> clazz, int radius) {
        return this.world.getEntitiesByClass(clazz).stream().filter(e -> this.isInRange(e.getLocation(), radius)).collect(Collectors.toList());
    }

    public boolean isWorldSame(@NotNull Location holder) {
        return this.getWorld().equals(holder.getWorld());
    }

    public boolean isInRange(@NotNull Location holder, int distance) {
        return this.getDistanceSquared(holder) < (double)distance;
    }

    public boolean outOfRange(@NotNull Location holder, int distance) {
        return this.getDistanceSquared(holder) >= (double)distance;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Location setDirection(@NotNull Vector3D vector) {
        double _2PI = Math.PI * 2;
        double x = vector.getX();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            float pitch = vector.getY() > 0.0 ? -90.0f : 90.0f;
            return new Location(this.x, this.y, this.z, this.yaw, pitch, this.world);
        }
        double theta = Math.atan2(-x, z);
        float yaw = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
        double x2 = Math.pow(x, 2.0);
        double z2 = Math.pow(z, 2.0);
        double xz = Math.sqrt(x2 + z2);
        float pitch = (float)Math.toDegrees(Math.atan(-vector.getY() / xz));
        return new Location(this.x, this.y, this.z, yaw, pitch, this.world);
    }

    @Generated
    public static LocationBuilder builder() {
        return new LocationBuilder();
    }

    @Generated
    public LocationBuilder toBuilder() {
        return new LocationBuilder().x(this.x).y(this.y).z(this.z).yaw(this.yaw).pitch(this.pitch).world(this.world);
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @NotNull
    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Location(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", world=" + String.valueOf(this.getWorld()) + ")";
    }

    @Generated
    public Location(double x, double y, double z, float yaw, float pitch, @NotNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.world = world;
    }

    @Generated
    public Location withX(double x) {
        return this.x == x ? this : new Location(x, this.y, this.z, this.yaw, this.pitch, this.world);
    }

    @Generated
    public Location withY(double y) {
        return this.y == y ? this : new Location(this.x, y, this.z, this.yaw, this.pitch, this.world);
    }

    @Generated
    public Location withZ(double z) {
        return this.z == z ? this : new Location(this.x, this.y, z, this.yaw, this.pitch, this.world);
    }

    @Generated
    public Location withYaw(float yaw) {
        return this.yaw == yaw ? this : new Location(this.x, this.y, this.z, yaw, this.pitch, this.world);
    }

    @Generated
    public Location withPitch(float pitch) {
        return this.pitch == pitch ? this : new Location(this.x, this.y, this.z, this.yaw, pitch, this.world);
    }

    @Generated
    public Location withWorld(@NotNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return this.world == world ? this : new Location(this.x, this.y, this.z, this.yaw, this.pitch, world);
    }

    @Generated
    public static class LocationBuilder {
        @Generated
        private double x;
        @Generated
        private double y;
        @Generated
        private double z;
        @Generated
        private float yaw;
        @Generated
        private float pitch;
        @Generated
        private World world;

        @Generated
        LocationBuilder() {
        }

        @Generated
        public LocationBuilder x(double x) {
            this.x = x;
            return this;
        }

        @Generated
        public LocationBuilder y(double y) {
            this.y = y;
            return this;
        }

        @Generated
        public LocationBuilder z(double z) {
            this.z = z;
            return this;
        }

        @Generated
        public LocationBuilder yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        @Generated
        public LocationBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Generated
        public LocationBuilder world(@NotNull World world) {
            if (world == null) {
                throw new NullPointerException("world is marked non-null but is null");
            }
            this.world = world;
            return this;
        }

        @Generated
        public Location build() {
            return new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.world);
        }

        @Generated
        public String toString() {
            return "Location.LocationBuilder(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", world=" + String.valueOf(this.world) + ")";
        }
    }
}

