/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w.dimension;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.world.dimension.DimensionRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface DimensionType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.DIMENSION_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static DimensionType of(@MinecraftType(value=MinecraftType.Type.DIMENSION_TYPE) @NotNull Object dimension) {
        DimensionType result = DimensionType.ofNullable(dimension);
        Preconditions.checkNotNullIllegal(result, "Could not find dimension: " + String.valueOf(dimension));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static DimensionType ofNullable(@MinecraftType(value=MinecraftType.Type.DIMENSION_TYPE) @Nullable Object dimension) {
        if (dimension instanceof DimensionType) {
            return (DimensionType)dimension;
        }
        return (DimensionType)DimensionRegistry.getInstance().resolveMapping(dimension);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull DimensionType> all() {
        return DimensionRegistry.getInstance().getRegistryItemStream();
    }
}

