/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w.weather;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.world.weather.WeatherRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface WeatherType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.WEATHER) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static WeatherType of(@MinecraftType(value=MinecraftType.Type.WEATHER) @NotNull Object weather) {
        WeatherType result = WeatherType.ofNullable(weather);
        Preconditions.checkNotNullIllegal(result, "Could not find weather: " + String.valueOf(weather));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static WeatherType ofNullable(@MinecraftType(value=MinecraftType.Type.WEATHER) @Nullable Object weather) {
        if (weather instanceof WeatherType) {
            return (WeatherType)weather;
        }
        return (WeatherType)WeatherRegistry.getInstance().resolveMapping(weather);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull WeatherType> all() {
        return WeatherRegistry.getInstance().getRegistryItemStream();
    }
}

