/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyListCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p list")
    @CommandPermission(value="sba.party")
    private void commandList(@NotNull Player sender) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(sender);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        Optional<IParty> optionnalParty = PartyManager.getInstance().getPartyOf(player);
        optionnalParty.ifPresent(party -> {
            Component leader = party.getPartyLeader().getDisplayName();
            ArrayList<Component> members = new ArrayList<Component>();
            party.getMembers().forEach(member -> {
                if (member != party.getPartyLeader()) {
                    members.add(member.getDisplayName());
                }
            });
            Component membersComponent = Component.join((Component)Component.text(","), members);
            LanguageService.getInstance().get(MessageKeys.PARTY_LIST).replace("%count%", String.valueOf(party.getMembers().size())).replace("%leader%", leader).replace("%members%", membersComponent).send(Players.wrapPlayer(sender));
        });
    }
}

