/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.service.AntiCheatIntegration;
import io.github.pronze.sba.utils.Logger;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.screamingsandals.bedwars.Main;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class ExplosionVelocityControlListener
implements Listener {
    private final Map<Player, BukkitTask> explosionAffectedPlayers = new HashMap<Player, BukkitTask>();

    @OnPostEnable
    public void postEnable() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        Entity entity;
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && (entity = event.getEntity()) instanceof Player && this.explosionAffectedPlayers.containsKey(player = (Player)entity)) {
            event.setDamage(SBAConfig.getInstance().node("tnt-fireball-jumping", "fall-damage").getDouble(3.0));
            Logger.trace("Landing tnt jump from fall damage", player);
            this.endTntJump(player);
        }
    }

    private void endTntJump(Player player) {
        BukkitTask potentialTask = this.explosionAffectedPlayers.get(player);
        if (potentialTask != null) {
            potentialTask.cancel();
        }
        this.explosionAffectedPlayers.remove(player);
        AntiCheatIntegration.getInstance().tntJumpLanding(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExplode(EntityExplodeEvent event) {
        Entity explodedEntity = event.getEntity();
        if (explodedEntity instanceof Explosive) {
            NamespacedKey entityKey;
            if (Version.isVersion(1, 20, 3) && "minecraft".equals((entityKey = explodedEntity.getType().getKey()).getNamespace()) && ("wind_charge".equals(entityKey.getKey()) || "breeze_wind_charge".equals(entityKey.getKey()))) {
                return;
            }
            double detectionDistance = SBAConfig.getInstance().node("tnt-fireball-jumping", "detection-distance").getDouble(5.0);
            explodedEntity.getWorld().getNearbyEntities(explodedEntity.getLocation(), detectionDistance, detectionDistance, detectionDistance).stream().filter(entity -> !entity.equals((Object)explodedEntity)).forEach(entity -> {
                Vector vector = entity.getLocation().clone().toVector().subtract(explodedEntity.getLocation().clone().add(0.0, SBAConfig.getInstance().node("tnt-fireball-jumping", "acceleration-y").getDouble(1.0), 0.0).toVector()).normalize();
                Logger.trace("{}", vector);
                vector.setY(vector.getY() / SBAConfig.getInstance().node("tnt-fireball-jumping", "reduce-y").getDouble(2.0));
                if (!Double.isFinite(vector.getY())) {
                    vector.setY(0);
                }
                if (!Double.isFinite(vector.getX())) {
                    vector.setX(0);
                }
                if (!Double.isFinite(vector.getZ())) {
                    vector.setZ(0);
                }
                vector.multiply(SBAConfig.getInstance().node("tnt-fireball-jumping", "launch-multiplier").getDouble(4.0));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.getGameMode() == GameMode.SPECTATOR || !Main.isPlayerInGame((Player)player)) {
                        return;
                    }
                    AntiCheatIntegration.getInstance().beginTntJump(player);
                    player.setVelocity(vector.add(player.getVelocity()));
                    this.explosionAffectedPlayers.put(player, this.startTask(player));
                    return;
                }
                if (Main.getInstance().isEntityInGame(entity)) {
                    entity.setVelocity(vector);
                }
            });
        }
    }

    public BukkitTask startTask(final Player player) {
        BukkitTask previousTask = this.explosionAffectedPlayers.get(player);
        if (previousTask != null) {
            previousTask.cancel();
        }
        return new BukkitRunnable(){
            boolean onGround = false;
            int count = 0;

            public void run() {
                if (player.isOnGround()) {
                    this.onGround = true;
                }
                if (this.onGround) {
                    ++this.count;
                }
                if (this.count > 3) {
                    this.cancel();
                    Logger.trace("Landing tnt jump from being on the ground for 1.5sec", player);
                    ExplosionVelocityControlListener.this.endTntJump(player);
                }
            }
        }.runTaskTimer((Plugin)SBA.getPluginInstance(), 20L, 10L);
    }
}

