/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.PartyInviteData;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import sba.sl.pa.ExtendablePlayer;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;

public class Party
implements IParty {
    @NotNull
    private SBAPlayerWrapper leader;
    private final UUID uuid;
    private final List<SBAPlayerWrapper> members;
    private final List<SBAPlayerWrapper> invitedPlayers;
    private final Map<UUID, PartyInviteData> inviteDataMap;
    private final PartySetting settings;

    public Party(@NotNull SBAPlayerWrapper leader) {
        this.leader = leader;
        this.uuid = UUID.randomUUID();
        this.members = new ArrayList<SBAPlayerWrapper>();
        this.invitedPlayers = new ArrayList<SBAPlayerWrapper>();
        this.inviteDataMap = new HashMap<UUID, PartyInviteData>();
        this.settings = new PartySetting();
        leader.getSettings().enable(PlayerSetting.IN_PARTY);
        this.members.add(leader);
    }

    @Override
    public List<SBAPlayerWrapper> getMembers() {
        return List.copyOf(this.members);
    }

    @Override
    public List<SBAPlayerWrapper> getInvitedPlayers() {
        return List.copyOf(this.invitedPlayers);
    }

    @Override
    public void sendMessage(@NotNull Component message, @NotNull SBAPlayerWrapper sender) {
        Component formattedMessage = LanguageService.getInstance().get(MessageKeys.PARTY_CHAT_FORMAT).replace("%name%", sender.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%message%", message).toComponent();
        this.members.forEach(player -> Players.wrapPlayer(player.getInstance()).sendMessage(formattedMessage));
    }

    @Override
    public void addPlayer(@NotNull SBAPlayerWrapper player) {
        PartyInviteData inviteData;
        this.invitedPlayers.remove(player);
        this.members.add(player);
        if (this.inviteDataMap.containsKey(player.getInstance().getUniqueId()) && (inviteData = this.inviteDataMap.get(player.getInstance().getUniqueId())) != null) {
            SBAUtil.cancelTask(inviteData.getInviteTask());
            player.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
            this.inviteDataMap.remove(player.getInstance().getUniqueId());
        }
    }

    @Override
    public void removePlayer(@NotNull SBAPlayerWrapper player) {
        this.members.remove(player);
        player.getSettings().disable(PlayerSetting.IN_PARTY);
    }

    @Override
    @NotNull
    public synchronized SBAPlayerWrapper getPartyLeader() {
        return this.leader;
    }

    @Override
    public synchronized void setPartyLeader(@NotNull SBAPlayerWrapper player) {
        if (player.equals(this.leader)) {
            return;
        }
        this.leader = player;
        if (!this.members.contains(this.leader)) {
            this.members.add(this.leader);
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void invitePlayer(final @NotNull SBAPlayerWrapper invitee, @NotNull SBAPlayerWrapper player) {
        if (this.inviteDataMap.containsKey(invitee.getInstance().getUniqueId())) {
            return;
        }
        this.invitedPlayers.add(invitee);
        invitee.getSettings().enable(PlayerSetting.INVITED_TO_PARTY);
        BukkitTask inviteTask = new BukkitRunnable(){

            public void run() {
                invitee.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
                Party.this.inviteDataMap.remove(invitee.getInstance().getUniqueId());
                if (Party.this.shouldDisband()) {
                    SBA.getInstance().getPartyManager().disband(Party.this.uuid);
                    Logger.trace("Disbanding party: {}", Party.this.uuid);
                }
                if (Party.this.getPartyLeader().isOnline()) {
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_EXPIRED).send(Party.this.getPartyLeader());
                }
            }
        }.runTaskLater((Plugin)SBA.getPluginInstance(), 20L * (long)SBAConfig.getInstance().party().expirationTime());
        PartyInviteData inviteData = PartyInviteData.of(invitee, player, inviteTask);
        this.inviteDataMap.put(invitee.getInstance().getUniqueId(), inviteData);
    }

    @Override
    public boolean isInvited(@NotNull SBAPlayerWrapper player) {
        return this.inviteDataMap.containsKey(player.getInstance().getUniqueId());
    }

    @Override
    public boolean shouldDisband() {
        return this.getInvitedPlayers().size() == 0 && this.getMembers().size() <= 1;
    }

    @Override
    public void removeInvitedPlayer(@NotNull SBAPlayerWrapper invitee) {
        if (!this.invitedPlayers.contains(invitee)) {
            return;
        }
        this.invitedPlayers.remove(invitee);
        invitee.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
    }

    public List<PartyInviteData> getInviteData() {
        return List.copyOf(this.inviteDataMap.values());
    }

    public String toString() {
        return "Party{uuid=" + String.valueOf(this.uuid) + ", leader=" + this.leader.as(Player.class).getDisplayName() + ", members=" + this.members.stream().map(ExtendablePlayer::getName).collect(Collectors.toList()).toString() + ", invitedPlayers=" + this.invitedPlayers.stream().map(ExtendablePlayer::getName).collect(Collectors.toList()).toString() + "}";
    }

    @Override
    public String debugInfo() {
        return "[leader=" + this.leader.as(Player.class).getDisplayName() + ", uuid=" + this.uuid.toString() + "]";
    }

    @Override
    public synchronized PartySetting getSettings() {
        return this.settings;
    }
}

