/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.bukkit;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.bukkit.BukkitCommandContextKeys;
import sba.cl.bukkit.BukkitCommandManager;
import sba.cl.bukkit.CloudBukkitCapabilities;
import sba.cl.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import sba.cl.execution.preprocessor.CommandPreprocessingContext;
import sba.cl.execution.preprocessor.CommandPreprocessor;

final class BukkitCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private final BukkitCommandManager<C> commandManager;
    private final Set<CloudBukkitCapabilities> bukkitCapabilities;
    private final @Nullable BukkitBackwardsBrigadierSenderMapper<C, ?> mapper;

    BukkitCommandPreprocessor(@NonNull BukkitCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.bukkitCapabilities = commandManager.queryCapabilities();
        this.mapper = this.bukkitCapabilities.contains((Object)CloudBukkitCapabilities.BRIGADIER) ? new BukkitBackwardsBrigadierSenderMapper(this.commandManager) : null;
    }

    @Override
    public void accept(@NonNull CommandPreprocessingContext<C> context) {
        if (this.mapper != null && !context.getCommandContext().contains("_cloud_brigadier_native_sender")) {
            context.getCommandContext().store("_cloud_brigadier_native_sender", this.mapper.apply(context.getCommandContext().getSender()));
        }
        context.getCommandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, this.commandManager.getBackwardsCommandSenderMapper().apply(context.getCommandContext().getSender()));
        context.getCommandContext().store(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES, this.bukkitCapabilities);
    }
}

