/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.execution;

import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.context.CommandContext;

@FunctionalInterface
public interface CommandExecutionHandler<C> {
    public void execute(@NonNull CommandContext<C> var1);

    default public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.execute(commandContext);
            future.complete(null);
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    @FunctionalInterface
    public static interface FutureCommandExecutionHandler<C>
    extends CommandExecutionHandler<C> {
        @Override
        default public void execute(@NonNull CommandContext<C> commandContext) {
        }

        @Override
        public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> var1);
    }

    public static class NullCommandExecutionHandler<C>
    implements CommandExecutionHandler<C> {
        @Override
        public void execute(@NonNull CommandContext<C> commandContext) {
        }
    }
}

