/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.permission;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.permission.AndPermission;
import sba.cl.permission.OrPermission;

public interface CommandPermission {
    public @NonNull Collection<@NonNull CommandPermission> getPermissions();

    public String toString();

    default public @NonNull CommandPermission or(@NonNull CommandPermission other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(2);
        permission.add(this);
        permission.add(other);
        return OrPermission.of(permission);
    }

    default public @NonNull CommandPermission or(CommandPermission ... other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(other.length + 1);
        permission.add(this);
        permission.addAll(Arrays.asList(other));
        return OrPermission.of(permission);
    }

    default public @NonNull CommandPermission and(@NonNull CommandPermission other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(2);
        permission.add(this);
        permission.add(other);
        return AndPermission.of(permission);
    }

    default public @NonNull CommandPermission and(CommandPermission ... other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(other.length + 1);
        permission.add(this);
        permission.addAll(Arrays.asList(other));
        return AndPermission.of(permission);
    }
}

