/*
 * Decompiled with CFR 0.152.
 */
package sba.si.action;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import sba.si.events.OnTradeEvent;
import sba.si.events.PostClickEvent;
import sba.si.events.PreClickEvent;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.IdentifiableEntry;
import sba.si.inventory.InventorySet;
import sba.si.inventory.LocalOptions;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Price;
import sba.si.inventory.SubInventory;
import sba.si.render.InventoryRenderer;
import sba.sl.pa.Player;
import sba.sl.u.ClickType;

public abstract class ClickActionHandler {
    protected void handleAction(InventoryRenderer inventoryRenderer, int slot, ClickType clickType) {
        List<Price> list;
        Optional<SubInventory> opt;
        Player playerWrapper = inventoryRenderer.getPlayer();
        SubInventory subInventory = inventoryRenderer.getSubInventory();
        LocalOptions options = subInventory.getLocalOptions();
        PlayerItemInfo playerItemInfo = inventoryRenderer.getItemInfoMap().get(slot);
        IdentifiableEntry parentItem = subInventory.getItemOwner();
        PreClickEvent preClickEvent = new PreClickEvent(playerWrapper, playerItemInfo, clickType, subInventory);
        if (playerItemInfo != null) {
            playerItemInfo.getOriginal().getEventManager().fireEvent(preClickEvent);
        } else {
            subInventory.getInventorySet().getEventManager().fireEvent(preClickEvent);
        }
        if (preClickEvent.cancelled()) {
            inventoryRenderer.close();
            return;
        }
        if (playerItemInfo == null) {
            if (slot == options.getRenderHeaderStart()) {
                if (!subInventory.isMain() && parentItem != null) {
                    SubInventory parent = parentItem.getParent();
                    int pageOfParent = parentItem instanceof GenericItemInfo ? ((GenericItemInfo)parentItem).getPosition() / parent.getLocalOptions().getItemsOnPage() : 0;
                    inventoryRenderer.jump(parent, pageOfParent);
                }
            } else if (slot == options.getRenderFooterStart()) {
                inventoryRenderer.previousPage();
            } else if (slot == options.getRenderFooterStart() + options.getItemsOnRow() - 1) {
                inventoryRenderer.nextPage();
            }
            return;
        }
        if (playerItemInfo.isDisabled()) {
            return;
        }
        if (playerItemInfo.hasChildInventory()) {
            inventoryRenderer.jump(playerItemInfo.getChildInventory());
            return;
        }
        if (playerItemInfo.getOriginal().hasBook()) {
            inventoryRenderer.close();
            playerWrapper.openBook(playerItemInfo.getOriginal().getBook());
            return;
        }
        if (playerItemInfo.getOriginal().getLocate() != null && (opt = playerItemInfo.getOriginal().getLocate().resolve()).isPresent()) {
            inventoryRenderer.jump(opt.get());
            return;
        }
        if (playerItemInfo.getFormat().isGenericShop() && !playerItemInfo.getOriginal().getPrices().isEmpty() && !(list = playerItemInfo.getOriginal().getPrices().stream().map(price -> {
            Price price1 = price.clone();
            if (price1.getCurrency() == null) {
                price1.setCurrency(playerItemInfo.getOriginal().getDefaultCurrency());
            }
            if (price1.getCurrency() == null && playerItemInfo.getFormat().isGenericShopPriceTypeRequired()) {
                price1 = null;
            }
            return price1;
        }).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            OnTradeEvent tradeEvent = new OnTradeEvent(playerWrapper, list, playerItemInfo.getOriginal().getItem().clone(), playerItemInfo, clickType, !playerItemInfo.getOriginal().getExecutions().isEmpty());
            playerItemInfo.getOriginal().getEventManager().fireEvent(tradeEvent);
            if (tradeEvent.isHasAnyExecutions() && tradeEvent.isRunExecutions()) {
                this.dispatchCommands(playerItemInfo, playerWrapper);
            }
            if (inventoryRenderer.isOpened()) {
                inventoryRenderer.render();
            }
            return;
        }
        if (!playerItemInfo.getOriginal().getExecutions().isEmpty()) {
            this.dispatchCommands(playerItemInfo, playerWrapper);
        }
        PostClickEvent postClickEvent = new PostClickEvent(playerWrapper, playerItemInfo, clickType, subInventory);
        playerItemInfo.getOriginal().getEventManager().fireEvent(postClickEvent);
        if (inventoryRenderer.isOpened()) {
            inventoryRenderer.render();
        }
    }

    private void dispatchCommands(PlayerItemInfo playerItemInfo, Player player) {
        InventorySet format = playerItemInfo.getFormat();
        playerItemInfo.getOriginal().getExecutions().forEach(s -> {
            if (s.startsWith("console:")) {
                if (format.isAllowAccessToConsole()) {
                    String command = format.processPlaceholders(player, s.split(":", 2)[1], playerItemInfo);
                    this.dispatchConsoleCommand(command);
                }
            } else if (s.startsWith("bungee:") || s.startsWith("proxy:")) {
                if (format.isAllowBungeecordPlayerSending()) {
                    String server = format.processPlaceholders(player, s.split(":", 2)[1], playerItemInfo);
                    this.movePlayerOnProxy(player, server);
                }
            } else {
                String command = format.processPlaceholders(player, s.startsWith("player:") ? s.split(":", 2)[1] : s, playerItemInfo);
                this.dispatchPlayerCommand(player, command);
            }
        });
    }

    protected abstract void dispatchPlayerCommand(Player var1, String var2);

    protected abstract void dispatchConsoleCommand(String var1);

    protected abstract void movePlayerOnProxy(Player var1, String var2);
}

