/*
 * Decompiled with CFR 0.152.
 */
package sba.si.builder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sba.si.SimpleInventoriesCore;
import sba.si.builder.ItemInfoBuilder;
import sba.si.inventory.Clone;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Price;
import sba.si.inventory.Times;
import sba.si.placeholders.RuntimeDefinedPlaceholder;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;

public class BuilderUtils {
    private static final Pattern REPEAT_MATCH_PATTERN = Pattern.compile("^(?<remain>.*)\\s+repeat\\s+(?<times>\\d+)$");
    private static final Pattern FOR_PRICE_MATCH_PATTERN = Pattern.compile("(?<remain>.*)\\s+for\\s+(?<price>[^\"]*)$");

    public static GenericItemInfo buildItem(InventorySet format, Object stack) {
        if (stack instanceof GenericItemInfo) {
            return (GenericItemInfo)stack;
        }
        if (stack instanceof String) {
            Matcher matcher_price;
            GenericItemInfo itemInfo = new GenericItemInfo(format);
            String enhancedShortStack = stack.toString();
            Matcher matcher_repeat = REPEAT_MATCH_PATTERN.matcher(enhancedShortStack);
            if (matcher_repeat.find()) {
                Times times = new Times();
                times.setRepeat(Integer.parseInt(matcher_repeat.group("times")));
                itemInfo.setRequestedTimes(times);
                enhancedShortStack = matcher_repeat.group("remain");
            }
            if ((matcher_price = FOR_PRICE_MATCH_PATTERN.matcher(enhancedShortStack)).find()) {
                Matcher matcher_one_price = ItemInfoBuilder.PRICE_PATTERN.matcher(matcher_price.group("price"));
                while (matcher_one_price.find()) {
                    Price price1 = new Price();
                    price1.setAmount(Integer.parseInt(matcher_one_price.group("price")));
                    price1.setCurrency(matcher_one_price.group("currency"));
                    itemInfo.getPrices().add(price1);
                }
                enhancedShortStack = matcher_price.group("remain");
            }
            if (enhancedShortStack.equalsIgnoreCase("cosmetic")) {
                Clone clone = new Clone();
                clone.setCloneLink("cosmetic");
                itemInfo.setRequestedClone(clone);
            } else {
                ItemStack item = ItemStackFactory.build(enhancedShortStack);
                itemInfo.setItem(item != null ? item : ItemStackFactory.getAir());
            }
            return itemInfo;
        }
        GenericItemInfo itemInfo = new GenericItemInfo(format);
        ItemStack item = ItemStackFactory.build(stack);
        itemInfo.setItem(item != null ? item : ItemStackFactory.getAir());
        return itemInfo;
    }

    public static void buildDefinition(InventorySet inventorySet, String definition) {
        String placeholderArguments;
        String[] defsplit = definition.split(" as ", 2);
        String key = defsplit[0].trim();
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        if (key.endsWith("%")) {
            key = key.substring(0, key.length() - 1);
        }
        String[] placeholderFormat = key.split("(?<!\\.)\\.(?!\\.)", 2);
        key = placeholderFormat[0];
        String string = placeholderArguments = placeholderFormat.length == 1 ? "" : placeholderFormat[1];
        if (inventorySet.getPlaceholders().containsKey(key) && !(inventorySet.getPlaceholders().get(key) instanceof RuntimeDefinedPlaceholder)) {
            SimpleInventoriesCore.getLogger().severe("Placeholder " + key + " is already defined as non-dynamic placeholder!");
            return;
        }
        if (!inventorySet.getPlaceholders().containsKey(key)) {
            inventorySet.registerPlaceholder(key, new RuntimeDefinedPlaceholder());
        }
        RuntimeDefinedPlaceholder parser = (RuntimeDefinedPlaceholder)inventorySet.getPlaceholders().get(key);
        if (defsplit.length == 2) {
            if (!placeholderArguments.isEmpty()) {
                parser.register(placeholderArguments, defsplit[1].trim());
            } else {
                parser.putDefault(defsplit[1].trim());
            }
        }
    }
}

