/*
 * Decompiled with CFR 0.152.
 */
package sba.si.bukkit.utils;

import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.utils.feature.PlatformFeature;
import sba.sl.u.reflect.Reflect;

public class InventoryUtils {
    @NotNull
    private static final PlatformFeature HOLDER_WITHOUT_SNAPSHOT = PlatformFeature.of(() -> Reflect.hasMethod(Inventory.class, "getHolder", Boolean.TYPE));

    public static Inventory getInventory(InventoryView view, int rawSlot) {
        if (rawSlot == -999) {
            return null;
        }
        if (rawSlot < view.getTopInventory().getSize()) {
            return view.getTopInventory();
        }
        return view.getBottomInventory();
    }

    public static InventoryHolder getInventoryHolderWithoutSnapshot(Inventory inventory) {
        if (HOLDER_WITHOUT_SNAPSHOT.isSupported()) {
            return inventory.getHolder(false);
        }
        return inventory.getHolder();
    }
}

