/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.a;

import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.a.AttributeModifier;
import sba.sl.a.AttributeType;
import sba.sl.api.Wrapper;
import sba.sl.impl.attribute.AttributeModifierIds;
import sba.sl.impl.attribute.Attributes;
import sba.sl.sl.EquipmentSlot;
import sba.sl.sl.EquipmentSlotGroup;
import sba.sl.u.Pair;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public class ItemAttribute
implements Wrapper {
    @NotNull
    private final AttributeType type;
    @NotNull
    private final ResourceLocation location;
    @Nullable
    private final UUID uuid;
    @Nullable
    private final String name;
    private final double amount;
    private final  @NotNull AttributeModifier.Operation operation;
    @NotNull
    private final EquipmentSlotGroup slot;

    public ItemAttribute(@NotNull AttributeType type, @NotNull ResourceLocation location, double amount,  @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlotGroup slot) {
        this.type = type;
        this.location = location;
        if (!Server.isVersion(1, 21)) {
            Pair<UUID, String> downgrade = AttributeModifierIds.downgradeResourceLocation(location);
            this.uuid = downgrade.first();
            this.name = downgrade.second();
        } else {
            this.uuid = null;
            this.name = null;
        }
        this.amount = amount;
        this.operation = operation;
        this.slot = slot;
    }

    public ItemAttribute(@NotNull AttributeType type, @NotNull UUID uuid, @NotNull String name, double amount,  @NotNull AttributeModifier.Operation operation, @Nullable EquipmentSlot slot) {
        this(type, uuid, name, amount, operation, slot == null ? EquipmentSlotGroup.of("any") : slot.asGroup());
    }

    public ItemAttribute(@NotNull AttributeType type, @NotNull UUID uuid, @NotNull String name, double amount,  @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlotGroup slot) {
        this.type = type;
        this.location = AttributeModifierIds.getResourceLocation(uuid, name);
        this.uuid = uuid;
        this.name = name;
        this.amount = amount;
        this.operation = operation;
        this.slot = slot;
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        return Attributes.convertItemAttributeHolder(this, type);
    }

    @NotNull
    @Generated
    public AttributeType getType() {
        return this.type;
    }

    @NotNull
    @Generated
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public  @NotNull AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    @NotNull
    @Generated
    public EquipmentSlotGroup getSlot() {
        return this.slot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemAttribute)) {
            return false;
        }
        ItemAttribute other = (ItemAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ResourceLocation this$location = this.getLocation();
        ResourceLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AttributeModifier.Operation this$operation = this.getOperation();
        AttributeModifier.Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        EquipmentSlotGroup this$slot = this.getSlot();
        EquipmentSlotGroup other$slot = other.getSlot();
        return !(this$slot == null ? other$slot != null : !this$slot.equals(other$slot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ItemAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ResourceLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AttributeModifier.Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        EquipmentSlotGroup $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ItemAttribute(type=" + String.valueOf(this.getType()) + ", location=" + String.valueOf(this.getLocation()) + ", uuid=" + String.valueOf(this.getUuid()) + ", name=" + this.getName() + ", amount=" + this.getAmount() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", slot=" + String.valueOf(this.getSlot()) + ")";
    }

    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.6; most likely contains null on 1.21+")
    @Nullable
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @ApiStatus.Obsolete
    @LimitedVersionSupport(value="<= 1.20.6; most likely contains null on 1.21+")
    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }
}

