/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface EntityTypeHolder
extends Wrapper {
    @NotNull
    public static EntityTypeHolder of(@NotNull Object entityType) {
        EntityTypeHolder result = EntityTypeHolder.ofNullable(entityType);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap entity type: " + String.valueOf(entityType));
        }
        return result;
    }

    @Nullable
    public static EntityTypeHolder ofNullable(@Nullable Object entityType) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + EntityTypeHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (entityType == null) {
            return null;
        }
        return Provider.provider.apply(entityType);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable EntityTypeHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable EntityTypeHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + EntityTypeHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

